/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.types.Instance;
import cc.mallet.util.Strings;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileIterator
implements Iterator<Instance> {
    FileFilter fileFilter;
    ArrayList<File> fileArray;
    Iterator<File> subIterator;
    Pattern targetPattern;
    File[] startingDirectories;
    int[] minFileIndex;
    int fileCount;
    int commonPrefixIndex;
    public static final Pattern STARTING_DIRECTORIES = Pattern.compile("_STARTING_DIRECTORIES_");
    public static final Pattern FIRST_DIRECTORY = Pattern.compile("/?([^/]*)/.+");
    public static final Pattern LAST_DIRECTORY = Pattern.compile(".*/([^/]+)/[^/]+");
    public static final Pattern ALL_DIRECTORIES = Pattern.compile("^(.*)/[^/]+");

    public ArrayList<File> getFileArray() {
        return this.fileArray;
    }

    protected FileIterator(File[] directories, FileFilter fileFilter, Pattern targetPattern, boolean removeCommonPrefix) {
        this.startingDirectories = directories;
        this.fileFilter = fileFilter;
        this.minFileIndex = new int[directories.length];
        this.fileArray = new ArrayList();
        this.targetPattern = targetPattern;
        for (int i = 0; i < directories.length; ++i) {
            if (!directories[i].isDirectory()) {
                throw new IllegalArgumentException(directories[i].getAbsolutePath() + " is not a directory.");
            }
            this.minFileIndex[i] = this.fileArray.size();
            this.fillFileArray(directories[i], fileFilter, this.fileArray);
        }
        this.subIterator = this.fileArray.iterator();
        this.fileCount = 0;
        String[] dirStrings = new String[directories.length];
        for (int i = 0; i < directories.length; ++i) {
            dirStrings[i] = directories[i].toString();
        }
        if (removeCommonPrefix) {
            this.commonPrefixIndex = Strings.commonPrefixIndex(dirStrings);
        }
    }

    public FileIterator(File[] directories, FileFilter fileFilter, Pattern targetPattern) {
        this(directories, fileFilter, targetPattern, false);
    }

    public FileIterator(File[] directories, Pattern targetPattern) {
        this(directories, null, targetPattern);
    }

    public FileIterator(File[] directories, Pattern targetPattern, boolean removeCommonPrefix) {
        this(directories, null, targetPattern, removeCommonPrefix);
    }

    public static File[] stringArray2FileArray(String[] sa) {
        File[] ret = new File[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            ret[i] = new File(sa[i]);
        }
        return ret;
    }

    public FileIterator(String[] directories, FileFilter ff) {
        this(FileIterator.stringArray2FileArray(directories), ff, null);
    }

    public FileIterator(String[] directories, String targetPattern) {
        this(FileIterator.stringArray2FileArray(directories), Pattern.compile(targetPattern));
    }

    public FileIterator(String[] directories, Pattern targetPattern) {
        this(FileIterator.stringArray2FileArray(directories), targetPattern);
    }

    public FileIterator(String[] directories, Pattern targetPattern, boolean removeCommonPrefix) {
        this(FileIterator.stringArray2FileArray(directories), targetPattern, removeCommonPrefix);
    }

    public FileIterator(File directory, FileFilter fileFilter, Pattern targetPattern) {
        this(new File[]{directory}, fileFilter, targetPattern);
    }

    public FileIterator(File directory, FileFilter fileFilter, Pattern targetPattern, boolean removeCommonPrefix) {
        this(new File[]{directory}, fileFilter, targetPattern, removeCommonPrefix);
    }

    public FileIterator(File directory, FileFilter fileFilter) {
        this(new File[]{directory}, fileFilter, null);
    }

    public FileIterator(File directory, Pattern targetPattern) {
        this(new File[]{directory}, null, targetPattern);
    }

    public FileIterator(File directory, Pattern targetPattern, boolean removeCommonPrefix) {
        this(new File[]{directory}, null, targetPattern, removeCommonPrefix);
    }

    public FileIterator(String directory, Pattern targetPattern) {
        this(new File[]{new File(directory)}, null, targetPattern);
    }

    public FileIterator(String directory, Pattern targetPattern, boolean removeCommonPrefix) {
        this(new File[]{new File(directory)}, null, targetPattern, removeCommonPrefix);
    }

    public FileIterator(File directory) {
        this(new File[]{directory}, null, null, false);
    }

    public FileIterator(String directory) {
        this(new File[]{new File(directory)}, null, null, false);
    }

    public FileIterator(String directory, FileFilter filter) {
        this(new File[]{new File(directory)}, filter, null);
    }

    private int fillFileArray(File directory, FileFilter filter, ArrayList<File> files) {
        int count = 0;
        File[] directoryContents = directory.listFiles();
        for (int i = 0; i < directoryContents.length; ++i) {
            if (directoryContents[i].isDirectory()) {
                count += this.fillFileArray(directoryContents[i], filter, files);
                continue;
            }
            if (filter != null && !filter.accept(directoryContents[i])) continue;
            files.add(directoryContents[i]);
            ++count;
        }
        return count;
    }

    @Override
    public Instance next() {
        Matcher m;
        File nextFile = this.subIterator.next();
        String path = nextFile.getAbsolutePath();
        String targetName = null;
        if (this.targetPattern == STARTING_DIRECTORIES) {
            int i;
            for (i = 0; i < this.minFileIndex.length && this.minFileIndex[i] <= this.fileCount; ++i) {
            }
            targetName = this.startingDirectories[--i].getPath().substring(this.commonPrefixIndex);
        } else if (this.targetPattern != null && (m = this.targetPattern.matcher(path)).find()) {
            targetName = m.group(1);
        }
        ++this.fileCount;
        return new Instance(nextFile, targetName, nextFile.toURI(), null);
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }

    public File nextFile() {
        return this.subIterator.next();
    }

    @Override
    public boolean hasNext() {
        return this.subIterator.hasNext();
    }
}

