/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.types.Instance;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcatenatedInstanceIterator
implements Iterator<Instance> {
    Iterator<Instance>[] iterators;
    Instance next;
    int iteratorIndex;

    public ConcatenatedInstanceIterator(Iterator<Instance>[] iterators) {
        this.iterators = iterators;
        this.iteratorIndex = 0;
        this.setNext();
    }

    private void setNext() {
        this.next = null;
        while (this.iteratorIndex < this.iterators.length && !this.iterators[this.iteratorIndex].hasNext()) {
            ++this.iteratorIndex;
        }
        if (this.iteratorIndex < this.iterators.length) {
            this.next = this.iterators[this.iteratorIndex].next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Instance next() {
        Instance ret = this.next;
        this.setNext();
        return ret;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }
}

