/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference;

import cc.mallet.grmm.inference.Inferencer;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.grmm.util.Models;

public abstract class AbstractInferencer
implements Inferencer,
Cloneable {
    private static final long serialVersionUID = 1L;

    public abstract void computeMarginals(FactorGraph var1);

    public double lookupJoint(Assignment assn) {
        return Math.exp(this.lookupLogJoint(assn));
    }

    public double lookupLogJoint(Assignment assn) {
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't compute joint probabilities.");
    }

    public Factor lookupMarginal(VarSet c) {
        switch (c.size()) {
            case 1: {
                return this.lookupMarginal(c.get(0));
            }
        }
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't compute marginals of arbitrary cliques.");
    }

    public double query(FactorGraph mdl, Assignment assn) {
        double marginal = 1.0;
        for (int i = 0; i < assn.size(); ++i) {
            Variable var = assn.getVariable(i);
            this.computeMarginals(mdl);
            Factor ptl = this.lookupMarginal(var);
            marginal *= ptl.value(assn);
            mdl = Models.addEvidence(mdl, new Assignment(var, assn.get(var)));
        }
        return marginal;
    }

    public abstract Factor lookupMarginal(Variable var1);

    public Inferencer duplicate() {
        try {
            return (Inferencer)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void dump() {
        throw new UnsupportedOperationException();
    }

    public void reportTime() {
        System.err.println("AbstractInferencer: reportTime(): No report available.");
    }
}

