/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker.handler;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

abstract class HostDevice {
    private HostDevice() {
    }

    static Map<String, String> getProperties() {
        TreeMap propertyMap = Maps.newTreeMap();
        ImmutableMap sysProps = Maps.fromProperties((Properties)System.getProperties());
        String version = (String)sysProps.get("java.version");
        String alternateVersion = (String)sysProps.get("java.runtime.version");
        if (alternateVersion != null && alternateVersion.length() > version.length()) {
            version = alternateVersion;
        }
        propertyMap.put("host.availableProcessors", Integer.toString(Runtime.getRuntime().availableProcessors()));
        String osName = (String)sysProps.get("os.name");
        propertyMap.put("os.name", osName);
        propertyMap.put("os.version", (String)sysProps.get("os.version"));
        propertyMap.put("os.arch", (String)sysProps.get("os.arch"));
        if (osName.equals("Linux")) {
            HostDevice.getLinuxEnvironment(propertyMap);
        }
        HostDevice.getAndroidEnvironment(propertyMap);
        return propertyMap;
    }

    private static void getLinuxEnvironment(Map<String, String> propertyMap) {
        Multimap<String, String> cpuInfo = HostDevice.propertiesFromLinuxFile("/proc/cpuinfo");
        propertyMap.put("host.cpus", Integer.toString(cpuInfo.get((Object)"processor").size()));
        String s = "cpu cores";
        propertyMap.put("host.cpu.cores", HostDevice.describe(cpuInfo, s));
        propertyMap.put("host.cpu.names", HostDevice.describe(cpuInfo, "model name"));
        propertyMap.put("host.cpu.cachesize", HostDevice.describe(cpuInfo, "cache size"));
        Multimap<String, String> memInfo = HostDevice.propertiesFromLinuxFile("/proc/meminfo");
        propertyMap.put("host.memory.physical", memInfo.get((Object)"MemTotal").toString());
        propertyMap.put("host.memory.swap", memInfo.get((Object)"SwapTotal").toString());
    }

    private static String describe(Multimap<String, String> cpuInfo, String s) {
        Collection strings = cpuInfo.get((Object)s);
        return strings.size() == 1 ? (String)strings.iterator().next() : ImmutableMultiset.copyOf((Iterable)strings).toString();
    }

    private static Multimap<String, String> propertiesFromLinuxFile(String file) {
        try {
            List lines = Files.readLines((File)new File(file), (Charset)Charset.defaultCharset());
            ImmutableMultimap.Builder result = ImmutableMultimap.builder();
            for (String line : lines) {
                String[] parts = line.split("\\s*\\:\\s*", 2);
                if (parts.length != 2) continue;
                result.put((Object)parts[0], (Object)parts[1]);
            }
            return result.build();
        }
        catch (IOException e) {
            return ImmutableMultimap.of();
        }
    }

    private static void getAndroidEnvironment(Map<String, String> propertyMap) {
        try {
            Class<?> androidOsBuildClass = ClassLoader.getSystemClassLoader().loadClass("android.os.Build");
            if (androidOsBuildClass != null) {
                String fingerprint = (String)androidOsBuildClass.getDeclaredField("FINGERPRINT").get(null);
                propertyMap.put("host.android.buildFingerprint", fingerprint != null ? fingerprint : "");
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

