/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_GuardedByUtils_GuardedByValidationResult;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByBinder;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByFlags;
import com.google.errorprone.bugpatterns.threadsafety.GuardedBySymbolResolver;
import com.google.errorprone.bugpatterns.threadsafety.IllegalGuardedBy;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import org.jspecify.annotations.Nullable;

public final class GuardedByUtils {
    public static ImmutableSet<String> getGuardValues(Symbol sym) {
        return GuardedByUtils.getAnnotationValueAsStrings(sym);
    }

    static ImmutableSet<String> getGuardValues(Tree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym == null) {
            return ImmutableSet.of();
        }
        return GuardedByUtils.getAnnotationValueAsStrings(sym);
    }

    private static ImmutableSet<String> getAnnotationValueAsStrings(Symbol sym) {
        List<Attribute.Compound> rawAttributes = sym.getRawAttributes();
        if (rawAttributes.isEmpty()) {
            return ImmutableSet.of();
        }
        return (ImmutableSet)rawAttributes.stream().filter(a -> a.getAnnotationType().asElement().getSimpleName().contentEquals("GuardedBy")).flatMap(a -> MoreAnnotations.getValue((Attribute.Compound)a, (String)"value").map(MoreAnnotations::asStrings).orElse(Stream.empty())).collect(ImmutableSet.toImmutableSet());
    }

    static JCTree.JCExpression parseString(String guardedByString, Context context) {
        JCTree.JCExpression exp;
        JavacParser parser = ParserFactory.instance(context).newParser(guardedByString, false, true, false);
        try {
            exp = parser.parseExpression();
        }
        catch (RuntimeException e) {
            throw new IllegalGuardedBy(e.getMessage());
        }
        int len = parser.getEndPos(exp) - exp.getStartPosition();
        if (len != guardedByString.length()) {
            throw new IllegalGuardedBy("Didn't parse entire string.");
        }
        return exp;
    }

    public static GuardedByValidationResult isGuardedByValid(Tree tree, VisitorState state, GuardedByFlags flags) {
        ImmutableSet<String> guards = GuardedByUtils.getGuardValues(tree, state);
        if (guards.isEmpty()) {
            return GuardedByValidationResult.ok();
        }
        ArrayList<GuardedByExpression> boundGuards = new ArrayList<GuardedByExpression>();
        for (String guard : guards) {
            Object boundGuard = GuardedByBinder.bindString(guard, GuardedBySymbolResolver.from(tree, state), flags);
            if (!((Optional)boundGuard).isPresent()) {
                return GuardedByValidationResult.invalid("could not resolve guard");
            }
            boundGuards.add((GuardedByExpression)((Optional)boundGuard).get());
        }
        Symbol treeSym = ASTHelpers.getSymbol((Tree)tree);
        if (treeSym == null) {
            return GuardedByValidationResult.ok();
        }
        for (Object boundGuard : boundGuards) {
            boolean staticGuard;
            Optional<GuardedByExpression> boundGuardRoot = ((GuardedByExpression)boundGuard).kind() == GuardedByExpression.Kind.SELECT ? ((GuardedByExpression.Select)boundGuard).root() : boundGuard;
            boolean parameterGuard = ((GuardedByExpression)((Object)boundGuardRoot)).sym() != null && ((GuardedByExpression)((Object)boundGuardRoot)).sym().getKind() == ElementKind.PARAMETER;
            boolean bl = staticGuard = ((GuardedByExpression)boundGuard).kind() == GuardedByExpression.Kind.CLASS_LITERAL || ((GuardedByExpression)boundGuard).sym() != null && ASTHelpers.isStatic((Symbol)((GuardedByExpression)boundGuard).sym());
            if (!ASTHelpers.isStatic((Symbol)treeSym) || staticGuard || parameterGuard) continue;
            return GuardedByValidationResult.invalid("static member guarded by instance");
        }
        return GuardedByValidationResult.ok();
    }

    public static @Nullable Symbol bindGuardedByString(Tree tree, String guard, VisitorState visitorState, GuardedByFlags flags) {
        Optional<GuardedByExpression> bound = GuardedByBinder.bindString(guard, GuardedBySymbolResolver.from(tree, visitorState), flags);
        if (!bound.isPresent()) {
            return null;
        }
        return bound.get().sym();
    }

    private GuardedByUtils() {
    }

    @AutoValue
    static abstract class GuardedByValidationResult {
        GuardedByValidationResult() {
        }

        abstract String message();

        abstract boolean isValid();

        static GuardedByValidationResult invalid(String message) {
            return new AutoValue_GuardedByUtils_GuardedByValidationResult(message, false);
        }

        static GuardedByValidationResult ok() {
            return new AutoValue_GuardedByUtils_GuardedByValidationResult("", true);
        }
    }
}

