/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Including fields in hashCode which are not compared in equals violates the contract of hashCode.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public final class InconsistentHashCode
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public static final String MESSAGE = "hashCode includes the fields %s, which equals does not. Two instances of this class could compare equal, but have different hashCodes, which violates the hashCode contract.";
    private static final Matcher<ExpressionTree> HASH_CODE_METHODS = MethodMatchers.instanceMethod().anyClass().named("hashCode").withNoParameters();
    private static final Matcher<ExpressionTree> EQUALS_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().anyClass().named("getClass"), Matchers.instanceEqualsInvocation()});

    public Description matchClass(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol((ClassTree)tree);
        MethodTree equalsDeclaration = null;
        MethodTree hashCodeDeclaration = null;
        for (Tree tree2 : tree.getMembers()) {
            if (!(tree2 instanceof MethodTree)) continue;
            MethodTree methodTree = (MethodTree)tree2;
            if (Matchers.hashCodeMethodDeclaration().matches((Tree)methodTree, state)) {
                hashCodeDeclaration = methodTree;
                continue;
            }
            if (!Matchers.equalsMethodDeclaration().matches((Tree)methodTree, state)) continue;
            equalsDeclaration = methodTree;
        }
        if (equalsDeclaration == null || hashCodeDeclaration == null) {
            return Description.NO_MATCH;
        }
        HashMap<Symbol.MethodSymbol, ImmutableSet<Symbol>> fieldsByMethod = new HashMap<Symbol.MethodSymbol, ImmutableSet<Symbol>>();
        for (Tree tree3 : tree.getMembers()) {
            FieldAccessFinder finder;
            MethodTree methodTree;
            if (!(tree3 instanceof MethodTree) || (methodTree = (MethodTree)tree3).equals(equalsDeclaration) || methodTree.equals(hashCodeDeclaration) || (finder = FieldAccessFinder.scanMethod(state, classSymbol, methodTree)).failed()) continue;
            fieldsByMethod.put(ASTHelpers.getSymbol((MethodTree)methodTree), finder.accessedFields());
        }
        FieldAccessFinder fieldAccessFinder = FieldAccessFinder.scanMethod(state, classSymbol, equalsDeclaration, fieldsByMethod, HASH_CODE_METHODS);
        FieldAccessFinder fieldAccessFinder2 = FieldAccessFinder.scanMethod(state, classSymbol, hashCodeDeclaration, fieldsByMethod, EQUALS_METHODS);
        if (fieldAccessFinder.failed() || fieldAccessFinder2.failed()) {
            return Description.NO_MATCH;
        }
        ImmutableSet<Symbol> fieldsInHashCode = fieldAccessFinder2.accessedFields();
        ImmutableSet<Symbol> fieldsInEquals = fieldAccessFinder.accessedFields();
        HashSet<Symbol> difference = new HashSet<Symbol>((Collection<Symbol>)Sets.difference(fieldsInHashCode, fieldsInEquals));
        difference.removeIf(f -> Ascii.toLowerCase((String)f.toString()).contains("hash"));
        String message = String.format(MESSAGE, difference);
        return difference.isEmpty() || fieldsInEquals.isEmpty() ? Description.NO_MATCH : this.buildDescription(hashCodeDeclaration).setMessage(message).build();
    }

    private static final class FieldAccessFinder
    extends TreeScanner<Void, Void> {
        private final Matcher<ExpressionTree> acceptableMethods;
        private final Map<Symbol.MethodSymbol, ImmutableSet<Symbol>> knownMethods;
        private final ImmutableSet.Builder<Symbol> accessedFields = ImmutableSet.builder();
        private final VisitorState state;
        private final Symbol.ClassSymbol classSymbol;
        private boolean failed = false;

        private static FieldAccessFinder scanMethod(VisitorState state, Symbol.ClassSymbol classSymbol, MethodTree methodTree) {
            return FieldAccessFinder.scanMethod(state, classSymbol, methodTree, (Map<Symbol.MethodSymbol, ImmutableSet<Symbol>>)ImmutableMap.of(), (Matcher<ExpressionTree>)Matchers.nothing());
        }

        private static FieldAccessFinder scanMethod(VisitorState state, Symbol.ClassSymbol classSymbol, MethodTree methodTree, Map<Symbol.MethodSymbol, ImmutableSet<Symbol>> knownMethods, Matcher<ExpressionTree> acceptableMethods) {
            FieldAccessFinder finder = new FieldAccessFinder(state, classSymbol, knownMethods, acceptableMethods);
            methodTree.accept(finder, null);
            return finder;
        }

        private FieldAccessFinder(VisitorState state, Symbol.ClassSymbol classSymbol, Map<Symbol.MethodSymbol, ImmutableSet<Symbol>> knownMethods, Matcher<ExpressionTree> acceptableMethods) {
            this.state = state;
            this.classSymbol = classSymbol;
            this.knownMethods = knownMethods;
            this.acceptableMethods = acceptableMethods;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
            if (this.knownMethods.containsKey(symbol)) {
                this.accessedFields.addAll((Iterable)this.knownMethods.get(symbol));
            } else if (!symbol.isStatic() && !this.acceptableMethods.matches((Tree)tree, this.state)) {
                this.failed = true;
            }
            return (Void)super.visitMethodInvocation(tree, null);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            ExpressionTree e = tree.getExpression();
            if (receiver == null || e instanceof IdentifierTree && ((IdentifierTree)e).getName().contentEquals("this")) {
                Symbol symbol = ((JCTree.JCFieldAccess)tree).sym;
                this.handleSymbol(symbol);
            }
            return (Void)super.visitMemberSelect(tree, null);
        }

        @Override
        public Void visitIdentifier(IdentifierTree tree, Void unused) {
            Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
            this.handleSymbol(symbol);
            return (Void)super.visitIdentifier(tree, null);
        }

        private void handleSymbol(Symbol symbol) {
            if (symbol != null && symbol.getKind() == ElementKind.FIELD && !ASTHelpers.isStatic((Symbol)symbol) && symbol.owner.equals(this.classSymbol)) {
                String name = symbol.name.toString();
                if (name.equals("this") || name.equals("super")) {
                    return;
                }
                this.accessedFields.add((Object)symbol);
            }
        }

        private ImmutableSet<Symbol> accessedFields() {
            return this.accessedFields.build();
        }

        public boolean failed() {
            return this.failed;
        }
    }
}

