/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.FieldMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Formattable;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@BugPattern(summary="Implicit use of the JVM default locale, which can result in differing behaviour between JVM executions.", severity=BugPattern.SeverityLevel.WARNING)
public class DefaultLocale
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Pattern SPECIFIER_ALLOW_LIST_REGEX = Pattern.compile("%([%n]|(\\d+\\$|<)?-?\\d*(\\.\\d+)?[bhsc])");
    private static final Supplier<Type> FORMATTABLE = Suppliers.typeFromClass(Formattable.class);
    private static final Supplier<Type> APPENDABLE = Suppliers.typeFromClass(Appendable.class);
    private static final Supplier<Type> PRINTSTREAM = Suppliers.typeFromClass(PrintStream.class);
    private static final ImmutableList<Supplier<Type>> PATTERN_AND_ARGS = ImmutableList.of((Object)Suppliers.STRING_TYPE, (Object)Suppliers.arrayOf((Supplier)Suppliers.OBJECT_TYPE));
    private static final Matcher<ExpressionTree> FORMAT_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOfAny(new String[]{PrintStream.class.getName(), PrintWriter.class.getName()}).namedAnyOf(new String[]{"format", "printf"}).withParametersOfType(PATTERN_AND_ARGS), Matchers.staticMethod().onClass(Suppliers.STRING_TYPE).named("format").withParametersOfType(PATTERN_AND_ARGS)});
    private static final Matcher<MethodInvocationTree> SYSTEM_OUT_RECEIVER = Matchers.receiverOfInvocation((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{FieldMatchers.staticField((String)System.class.getName(), (String)"out"), FieldMatchers.staticField((String)System.class.getName(), (String)"err")}));
    private static final Matcher<ExpressionTree> STRING_FORMATTED = Matchers.instanceMethod().onExactClass(Suppliers.STRING_TYPE).named("formatted");
    private static final Matcher<ExpressionTree> DISPLAY_METHODS = Matchers.instanceMethod().onExactClass("java.util.Currency").named("getSymbol").withNoParameters();
    private static final Matcher<ExpressionTree> FACTORIES = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.text.BreakIterator").namedAnyOf(new String[]{"getCharacterInstance", "getLineInstance", "getSentenceInstance", "getWordInstance"}).withNoParameters(), Matchers.staticMethod().onClass("java.text.Collator").named("getInstance").withNoParameters()});
    private static final Matcher<ExpressionTree> FORMATTER_FACTORIES = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.text.NumberFormat").namedAnyOf(new String[]{"getCompactNumberInstance", "getCurrencyInstance", "getInstance", "getIntegerInstance", "getNumberInstance", "getPercentInstance"}).withNoParameters(), Matchers.staticMethod().onClass("java.text.DateFormatSymbols").named("getInstance").withNoParameters(), Matchers.staticMethod().onClass("java.text.DecimalFormatSymbols").named("getInstance").withNoParameters(), Matchers.staticMethod().onClass("java.time.format.DateTimeFormatter").named("ofPattern").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.STRING_TYPE)), Matchers.instanceMethod().onDescendantOf("java.time.format.DateTimeFormatterBuilder").named("toFormatter").withNoParameters()});
    private static final Matcher<ExpressionTree> DATE_FORMAT = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.text.DateFormat").named("getInstance").withNoParameters(), Matchers.staticMethod().onClass("java.text.DateFormat").namedAnyOf(new String[]{"getDateInstance", "getTimeInstance"}).withNoParameters(), Matchers.staticMethod().onClass("java.text.DateFormat").namedAnyOf(new String[]{"getDateInstance", "getTimeInstance"}).withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.INT_TYPE)), Matchers.staticMethod().onClass("java.text.DateFormat").named("getDateTimeInstance").withNoParameters(), Matchers.staticMethod().onClass("java.text.DateFormat").named("getDateTimeInstance").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.INT_TYPE, (Object)Suppliers.INT_TYPE))});
    private static final Matcher<ExpressionTree> MESSAGEFORMAT_FORMAT = Matchers.staticMethod().onClass("java.text.MessageFormat").named("format").withParametersOfType(PATTERN_AND_ARGS);
    private static final Matcher<ExpressionTree> RESOURCE_BUNDLE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.util.ResourceBundle").named("getBundle").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.STRING_TYPE)), Matchers.staticMethod().onClass("java.util.ResourceBundle").named("getBundle").withParameters("java.lang.String", new String[]{"java.util.ResourceBundle.Control"}), Matchers.staticMethod().onClass("java.util.ResourceBundle").named("getBundle").withParameters("java.lang.String", new String[]{"java.lang.Module"})});
    private static final Matcher<ExpressionTree> FORMAT_CONSTRUCTORS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.constructor().forClass("java.text.MessageFormat").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.STRING_TYPE)), Matchers.constructor().forClass("java.text.DateFormatSymbols").withNoParameters(), Matchers.constructor().forClass("java.text.DecimalFormatSymbols").withNoParameters()});
    private static final Matcher<ExpressionTree> DECIMAL_FORMAT = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.constructor().forClass("java.text.DecimalFormat").withNoParameters(), Matchers.constructor().forClass("java.text.DecimalFormat").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.STRING_TYPE))});
    private static final Matcher<ExpressionTree> SIMPLE_DATE_FORMAT = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.constructor().forClass("java.text.SimpleDateFormat").withNoParameters(), Matchers.constructor().forClass("java.text.SimpleDateFormat").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.STRING_TYPE))});
    private static final Matcher<ExpressionTree> FORMATTER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.constructor().forClass("java.util.Formatter").withNoParameters(), Matchers.constructor().forClass("java.util.Formatter").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.STRING_TYPE)), Matchers.constructor().forClass("java.util.Formatter").withParametersOfType((Iterable)ImmutableList.of((Object)Suppliers.STRING_TYPE, (Object)Suppliers.STRING_TYPE)), Matchers.constructor().forClass("java.util.Formatter").withParameters("java.lang.Appendable", new String[0]), Matchers.constructor().forClass("java.util.Formatter").withParameters("java.io.File", new String[0]), Matchers.constructor().forClass("java.util.Formatter").withParameters("java.io.File", new String[]{"java.lang.String"}), Matchers.constructor().forClass("java.util.Formatter").withParameters("java.io.PrintStream", new String[0]), Matchers.constructor().forClass("java.util.Formatter").withParameters("java.io.OutputStream", new String[0]), Matchers.constructor().forClass("java.util.Formatter").withParameters("java.io.OutputStream", new String[]{"java.lang.String"})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (FORMAT_METHODS.matches((Tree)tree, state)) {
            if (SYSTEM_OUT_RECEIVER.matches((Tree)tree, state) || !this.shouldRefactorStringFormat(tree.getArguments().get(0), (List)tree.getArguments().stream().skip(1L).collect(ImmutableList.toImmutableList()), state)) {
                return Description.NO_MATCH;
            }
            return this.prependLocales(tree, state, LocaleFix.ROOT_FIX, LocaleFix.DEFAULT_LOCALE_FIX, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX);
        }
        if (STRING_FORMATTED.matches((Tree)tree, state)) {
            return this.handleStringFormatted(tree, state);
        }
        if (DISPLAY_METHODS.matches((Tree)tree, state)) {
            return this.appendLocales(tree, state, LocaleFix.ROOT_FIX, LocaleFix.DEFAULT_LOCALE_FIX, LocaleFix.DEFAULT_DISPLAY_LOCALE_FIX);
        }
        if (FACTORIES.matches((Tree)tree, state)) {
            return this.appendLocales(tree, state, LocaleFix.ROOT_FIX, LocaleFix.DEFAULT_LOCALE_FIX);
        }
        if (FORMATTER_FACTORIES.matches((Tree)tree, state)) {
            return this.appendLocales(tree, state, LocaleFix.ROOT_FIX, LocaleFix.DEFAULT_LOCALE_FIX, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX);
        }
        if (DATE_FORMAT.matches((Tree)tree, state)) {
            return this.handleDateFormat(tree, state);
        }
        if (MESSAGEFORMAT_FORMAT.matches((Tree)tree, state)) {
            return this.handleMessageFormatFormat(tree, state);
        }
        if (RESOURCE_BUNDLE.matches((Tree)tree, state)) {
            return this.handleResourceBundle(tree, state);
        }
        return Description.NO_MATCH;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (FORMAT_CONSTRUCTORS.matches((Tree)tree, state)) {
            return this.appendLocales(tree, state, LocaleFix.ROOT_FIX, LocaleFix.DEFAULT_LOCALE_FIX, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX);
        }
        if (DECIMAL_FORMAT.matches((Tree)tree, state)) {
            return this.handleDecimalFormat(tree, state);
        }
        if (SIMPLE_DATE_FORMAT.matches((Tree)tree, state)) {
            return this.handleSimpleDateFormat(tree, state);
        }
        if (FORMATTER.matches((Tree)tree, state)) {
            return this.handleFormatter(tree, state);
        }
        return Description.NO_MATCH;
    }

    private Description handleStringFormatted(MethodInvocationTree tree, VisitorState state) {
        if (!this.shouldRefactorStringFormat(ASTHelpers.getReceiver((ExpressionTree)tree), tree.getArguments(), state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        description.addFix(this.stringFormattedFix(tree, state, LocaleFix.ROOT_FIX));
        description.addFix(this.stringFormattedFix(tree, state, LocaleFix.DEFAULT_LOCALE_FIX));
        description.addFix(this.stringFormattedFix(tree, state, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX));
        return description.build();
    }

    private Fix stringFormattedFix(MethodInvocationTree tree, VisitorState state, LocaleFix localeFix) {
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription(localeFix.title());
        Object[] objectArray = new Object[3];
        objectArray[0] = localeFix.replacement(fix, state);
        objectArray[1] = state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)tree));
        objectArray[2] = tree.getArguments().stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(", "));
        fix.replace((Tree)tree, String.format("String.format(%s, %s, %s)", objectArray));
        return fix.build();
    }

    private Description handleDateFormat(MethodInvocationTree tree, VisitorState state) {
        Description.Builder description = this.buildDescription(tree);
        javax.lang.model.element.Name methodName = ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName();
        if (((Name)methodName).contentEquals("getInstance")) {
            this.dateFormatGetInstanceFixes(description, tree, state);
        } else if (((Name)methodName).contentEquals("getDateTimeInstance")) {
            this.dateFormatFixes(description, tree, state, 2);
        } else {
            this.dateFormatFixes(description, tree, state, 1);
        }
        return description.build();
    }

    private void dateFormatGetInstanceFixes(Description.Builder description, MethodInvocationTree tree, VisitorState state) {
        description.addFix(this.dateFormatGetInstanceFix(tree, state, LocaleFix.ROOT_FIX));
        description.addFix(this.dateFormatGetInstanceFix(tree, state, LocaleFix.DEFAULT_LOCALE_FIX));
        description.addFix(this.dateFormatGetInstanceFix(tree, state, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX));
    }

    private Fix dateFormatGetInstanceFix(MethodInvocationTree tree, VisitorState state, LocaleFix localeFix) {
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription(localeFix.title());
        fix.replace(state.getEndPosition((Tree)tree.getMethodSelect()), state.getEndPosition((Tree)tree), String.format("(%1$s, %<s, %2$s)", SuggestedFixes.qualifyStaticImport((String)"java.text.DateFormat.SHORT", (SuggestedFix.Builder)fix, (VisitorState)state), localeFix.replacement(fix, state))).merge(SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"getDateTimeInstance", (VisitorState)state));
        return fix.build();
    }

    private void dateFormatFixes(Description.Builder description, MethodInvocationTree tree, VisitorState state, int nonLocaleArgs) {
        description.addFix(this.dateFormatFix(tree, state, nonLocaleArgs, LocaleFix.ROOT_FIX));
        description.addFix(this.dateFormatFix(tree, state, nonLocaleArgs, LocaleFix.DEFAULT_LOCALE_FIX));
        description.addFix(this.dateFormatFix(tree, state, nonLocaleArgs, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX));
    }

    private Fix dateFormatFix(MethodInvocationTree tree, VisitorState state, int nonLocaleArgs, LocaleFix localeFix) {
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription(localeFix.title());
        if (tree.getArguments().isEmpty()) {
            String defaultConst = SuggestedFixes.qualifyStaticImport((String)"java.text.DateFormat.DEFAULT", (SuggestedFix.Builder)fix, (VisitorState)state);
            fix.replace(state.getEndPosition((Tree)tree.getMethodSelect()), state.getEndPosition((Tree)tree), String.format("(%s, %s)", Stream.generate(() -> defaultConst).limit(nonLocaleArgs).collect(Collectors.joining(", ")), localeFix.replacement(fix, state)));
        } else {
            fix.postfixWith((Tree)Iterables.getLast(tree.getArguments()), ", " + localeFix.replacement(fix, state));
        }
        return fix.build();
    }

    private Description handleMessageFormatFormat(MethodInvocationTree tree, VisitorState state) {
        ImmutableList arguments;
        ExpressionTree pattern = tree.getArguments().get(0);
        if (!this.shouldRefactorStringFormat(pattern, (List<? extends ExpressionTree>)(arguments = (ImmutableList)tree.getArguments().stream().skip(1L).collect(ImmutableList.toImmutableList())), state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        description.addFix(this.messageFormatFormatFix(tree, pattern, (ImmutableList<? extends ExpressionTree>)arguments, state, LocaleFix.ROOT_FIX));
        description.addFix(this.messageFormatFormatFix(tree, pattern, (ImmutableList<? extends ExpressionTree>)arguments, state, LocaleFix.DEFAULT_LOCALE_FIX));
        description.addFix(this.messageFormatFormatFix(tree, pattern, (ImmutableList<? extends ExpressionTree>)arguments, state, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX));
        return description.build();
    }

    private boolean shouldRefactorStringFormat(ExpressionTree pattern, List<? extends ExpressionTree> arguments, VisitorState state) {
        String patternValue = (String)ASTHelpers.constValue((Tree)pattern, String.class);
        if (patternValue != null && !DefaultLocale.onlyContainsSpecifiersInAllowList(patternValue)) {
            return true;
        }
        return this.containsSomeFormattableArgument(arguments, state);
    }

    @VisibleForTesting
    static boolean onlyContainsSpecifiersInAllowList(String pattern) {
        String noSpecifierFormatBase = SPECIFIER_ALLOW_LIST_REGEX.matcher(pattern).replaceAll("");
        return !noSpecifierFormatBase.contains("%");
    }

    private boolean containsSomeFormattableArgument(List<? extends ExpressionTree> arguments, VisitorState state) {
        return arguments.stream().anyMatch(tree -> this.mightBeFormattable((ExpressionTree)tree, state));
    }

    private boolean mightBeFormattable(ExpressionTree tree, VisitorState state) {
        if (tree instanceof LiteralTree) {
            return false;
        }
        return ASTHelpers.isSubtype((Type)ASTHelpers.getResultType((ExpressionTree)tree), (Type)((Type)FORMATTABLE.get(state)), (VisitorState)state);
    }

    private Fix messageFormatFormatFix(MethodInvocationTree tree, ExpressionTree pattern, ImmutableList<? extends ExpressionTree> arguments, VisitorState state, LocaleFix localeFix) {
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription(localeFix.title());
        Object[] objectArray = new Object[4];
        objectArray[0] = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"java.text.MessageFormat");
        objectArray[1] = state.getSourceForNode((Tree)pattern);
        objectArray[2] = localeFix.replacement(fix, state);
        objectArray[3] = arguments.stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(", "));
        fix.replace((Tree)tree, String.format("new %s(%s, %s).format(%s)", objectArray));
        return fix.build();
    }

    private Description handleResourceBundle(MethodInvocationTree tree, VisitorState state) {
        Description.Builder description = this.buildDescription(tree);
        description.addFix(this.resourceBundleFix(tree, state, LocaleFix.ROOT_FIX));
        description.addFix(this.resourceBundleFix(tree, state, LocaleFix.DEFAULT_LOCALE_FIX));
        return description.build();
    }

    private Fix resourceBundleFix(MethodInvocationTree tree, VisitorState state, LocaleFix localeFix) {
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription(localeFix.title());
        fix.postfixWith((Tree)tree.getArguments().get(0), ", " + localeFix.replacement(fix, state));
        return fix.build();
    }

    private Description handleDecimalFormat(NewClassTree tree, VisitorState state) {
        Description.Builder description = this.buildDescription(tree);
        if (tree.getArguments().isEmpty()) {
            description.addFix(this.decimalFormatToNumberFormatFix(tree, state, LocaleFix.ROOT_FIX));
            description.addFix(this.decimalFormatToNumberFormatFix(tree, state, LocaleFix.DEFAULT_LOCALE_FIX));
            description.addFix(this.decimalFormatToNumberFormatFix(tree, state, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX));
        } else {
            description.addFix(this.decimalFormatFix(tree, state, LocaleFix.ROOT_FIX));
            description.addFix(this.decimalFormatFix(tree, state, LocaleFix.DEFAULT_LOCALE_FIX));
            description.addFix(this.decimalFormatFix(tree, state, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX));
        }
        return description.build();
    }

    private Fix decimalFormatToNumberFormatFix(NewClassTree tree, VisitorState state, LocaleFix localeFix) {
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription(localeFix.title()).addImport("java.text.NumberFormat");
        fix.replace((Tree)tree, String.format("NumberFormat.getInstance(%s)", localeFix.replacement(fix, state)));
        return fix.build();
    }

    private Fix decimalFormatFix(NewClassTree tree, VisitorState state, LocaleFix localeFix) {
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription(localeFix.title()).addImport("java.text.DecimalFormatSymbols");
        fix.postfixWith((Tree)Iterables.getLast(tree.getArguments()), String.format(", DecimalFormatSymbols.getInstance(%s)", localeFix.replacement(fix, state)));
        return fix.build();
    }

    private Description handleSimpleDateFormat(NewClassTree tree, VisitorState state) {
        Description.Builder description = this.buildDescription(tree);
        if (tree.getArguments().isEmpty()) {
            description.addFix(this.simpleDateFormatToDateFormatFix(tree, state, LocaleFix.ROOT_FIX));
            description.addFix(this.simpleDateFormatToDateFormatFix(tree, state, LocaleFix.DEFAULT_LOCALE_FIX));
            description.addFix(this.simpleDateFormatToDateFormatFix(tree, state, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX));
        } else {
            description.addFix(this.simpleDateFormatFix(tree, state, LocaleFix.ROOT_FIX));
            description.addFix(this.simpleDateFormatFix(tree, state, LocaleFix.DEFAULT_LOCALE_FIX));
            description.addFix(this.simpleDateFormatFix(tree, state, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX));
        }
        return description.build();
    }

    private Fix simpleDateFormatToDateFormatFix(NewClassTree tree, VisitorState state, LocaleFix localeFix) {
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription(localeFix.title()).addImport("java.text.DateFormat");
        fix.replace((Tree)tree, String.format("DateFormat.getDateTimeInstance(%1$s, %<s, %2$s)", SuggestedFixes.qualifyStaticImport((String)"java.text.DateFormat.SHORT", (SuggestedFix.Builder)fix, (VisitorState)state), localeFix.replacement(fix, state)));
        return fix.build();
    }

    private Fix simpleDateFormatFix(NewClassTree tree, VisitorState state, LocaleFix localeFix) {
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription(localeFix.title());
        fix.postfixWith((Tree)Iterables.getLast(tree.getArguments()), ", " + localeFix.replacement(fix, state));
        return fix.build();
    }

    private Description handleFormatter(NewClassTree tree, VisitorState state) {
        if (tree.getArguments().isEmpty() || tree.getArguments().size() == 2) {
            return this.appendLocales(tree, state, LocaleFix.ROOT_FIX, LocaleFix.DEFAULT_LOCALE_FIX, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX);
        }
        Type argType = ASTHelpers.getResultType((ExpressionTree)((ExpressionTree)Iterables.getOnlyElement(tree.getArguments())));
        if (ASTHelpers.isSubtype((Type)argType, (Type)((Type)APPENDABLE.get(state)), (VisitorState)state) && !ASTHelpers.isSubtype((Type)argType, (Type)((Type)PRINTSTREAM.get(state)), (VisitorState)state)) {
            return this.appendLocales(tree, state, LocaleFix.ROOT_FIX, LocaleFix.DEFAULT_LOCALE_FIX, LocaleFix.DEFAULT_FORMAT_LOCALE_FIX);
        }
        return this.buildDescription(tree).build();
    }

    private Description prependLocales(MethodInvocationTree tree, VisitorState state, LocaleFix ... localeFixes) {
        return this.prependLocales((Tree)tree, tree.getMethodSelect(), tree.getArguments(), state, localeFixes);
    }

    private Description prependLocales(Tree tree, Tree select, List<? extends ExpressionTree> arguments, VisitorState state, LocaleFix ... localeFixes) {
        Description.Builder description = this.buildDescription(tree);
        for (LocaleFix localeFix : localeFixes) {
            description.addFix(this.prependLocale(tree, select, arguments, state, localeFix));
        }
        return description.build();
    }

    private Fix prependLocale(Tree tree, Tree select, List<? extends ExpressionTree> arguments, VisitorState state, LocaleFix localeFix) {
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription(localeFix.title());
        if (arguments.isEmpty()) {
            fix.replace(state.getEndPosition(select), state.getEndPosition(tree), String.format("(%s)", localeFix.replacement(fix, state)));
        } else {
            fix.prefixWith((Tree)arguments.get(0), localeFix.replacement(fix, state) + ", ");
        }
        return fix.build();
    }

    private Description appendLocales(MethodInvocationTree tree, VisitorState state, LocaleFix ... localeFixes) {
        return this.appendLocales((Tree)tree, tree.getMethodSelect(), tree.getArguments(), state, localeFixes);
    }

    private Description appendLocales(NewClassTree tree, VisitorState state, LocaleFix ... localeFixes) {
        return this.appendLocales((Tree)tree, tree.getIdentifier(), tree.getArguments(), state, localeFixes);
    }

    private Description appendLocales(Tree tree, Tree select, List<? extends ExpressionTree> arguments, VisitorState state, LocaleFix ... localeFixes) {
        Description.Builder description = this.buildDescription(tree);
        for (LocaleFix localeFix : localeFixes) {
            description.addFix(this.appendLocale(tree, select, arguments, state, localeFix));
        }
        return description.build();
    }

    private Fix appendLocale(Tree tree, Tree select, List<? extends ExpressionTree> arguments, VisitorState state, LocaleFix localeFix) {
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription(localeFix.title());
        if (arguments.isEmpty()) {
            fix.replace(state.getEndPosition(select), state.getEndPosition(tree), String.format("(%s)", localeFix.replacement(fix, state)));
        } else {
            fix.postfixWith((Tree)Iterables.getLast(arguments), ", " + localeFix.replacement(fix, state));
        }
        return fix.build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum LocaleFix {
        ROOT_FIX("Specify ROOT locale"){

            @Override
            String replacement(SuggestedFix.Builder fix, VisitorState state) {
                fix.addImport("java.util.Locale");
                return "Locale.ROOT";
            }
        }
        ,
        DEFAULT_LOCALE_FIX("Specify default locale"){

            @Override
            String replacement(SuggestedFix.Builder fix, VisitorState state) {
                fix.addImport("java.util.Locale");
                return "Locale.getDefault()";
            }
        }
        ,
        DEFAULT_DISPLAY_LOCALE_FIX("Specify default display locale"){

            @Override
            String replacement(SuggestedFix.Builder fix, VisitorState state) {
                fix.addImport("java.util.Locale");
                return String.format("Locale.getDefault(%s)", SuggestedFixes.qualifyStaticImport((String)"java.util.Locale.Category.DISPLAY", (SuggestedFix.Builder)fix, (VisitorState)state));
            }
        }
        ,
        DEFAULT_FORMAT_LOCALE_FIX("Specify default format locale"){

            @Override
            String replacement(SuggestedFix.Builder fix, VisitorState state) {
                fix.addImport("java.util.Locale");
                return String.format("Locale.getDefault(%s)", SuggestedFixes.qualifyStaticImport((String)"java.util.Locale.Category.FORMAT", (SuggestedFix.Builder)fix, (VisitorState)state));
            }
        };

        private final String title;

        private LocaleFix(String title) {
            this.title = title;
        }

        String title() {
            return this.title;
        }

        abstract String replacement(SuggestedFix.Builder var1, VisitorState var2);
    }
}

