/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.io.Serializable;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;

abstract class AbstractJUnit4InitMethodNotRun
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String JUNIT_TEST = "org.junit.Test";

    AbstractJUnit4InitMethodNotRun() {
    }

    protected abstract Matcher<MethodTree> methodMatcher();

    protected abstract String correctAnnotation();

    protected abstract List<AnnotationReplacements> annotationReplacements();

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        boolean matches = Matchers.allOf((Matcher[])new Matcher[]{this.methodMatcher(), Matchers.not((Matcher)Matchers.hasAnnotationOnAnyOverriddenMethod((String)JUNIT_TEST)), Matchers.enclosingClass((Matcher)JUnitMatchers.isJUnit4TestClass)}).matches((Tree)methodTree, state);
        if (!matches) {
            return Description.NO_MATCH;
        }
        for (AnnotationReplacements replacement : this.annotationReplacements()) {
            Description description = this.tryToReplaceAnnotation(methodTree, state, replacement.badAnnotation, replacement.goodAnnotation);
            if (description == null) continue;
            return description;
        }
        String correctAnnotation = this.correctAnnotation();
        String unqualifiedClassName = AbstractJUnit4InitMethodNotRun.getUnqualifiedClassName(correctAnnotation);
        for (AnnotationTree annotationTree : methodTree.getModifiers().getAnnotations()) {
            Symbol annoSymbol = ASTHelpers.getSymbol((Tree)annotationTree);
            if (!annoSymbol.getSimpleName().contentEquals(unqualifiedClassName)) continue;
            SuggestedFix.Builder suggestedFix = SuggestedFix.builder().removeImport(annoSymbol.getQualifiedName().toString()).addImport(correctAnnotation);
            AbstractJUnit4InitMethodNotRun.makeProtectedPublic(methodTree, state, suggestedFix);
            return this.describeMatch(annotationTree, (Fix)suggestedFix.build());
        }
        SuggestedFix.Builder suggestedFix = SuggestedFix.builder().addImport(correctAnnotation);
        AbstractJUnit4InitMethodNotRun.makeProtectedPublic(methodTree, state, suggestedFix);
        suggestedFix.prefixWith((Tree)methodTree, "@" + unqualifiedClassName + "\n");
        return this.describeMatch(methodTree, (Fix)suggestedFix.build());
    }

    private static void makeProtectedPublic(MethodTree methodTree, VisitorState state, SuggestedFix.Builder suggestedFix) {
        if (Matchers.hasModifier((Modifier)Modifier.PROTECTED).matches((Tree)methodTree, state)) {
            ModifiersTree modifiers = methodTree.getModifiers();
            String modifiersSource = state.getSourceForNode((Tree)modifiers);
            suggestedFix.replace((Tree)modifiers, modifiersSource.toString().replaceFirst("protected", "public"));
        }
    }

    private @Nullable Description tryToReplaceAnnotation(MethodTree methodTree, VisitorState state, String badAnnotation, String goodAnnotation) {
        String finalName = AbstractJUnit4InitMethodNotRun.getUnqualifiedClassName(goodAnnotation);
        if (Matchers.hasAnnotation((String)badAnnotation).matches((Tree)methodTree, state)) {
            AnnotationTree annotationTree = AbstractJUnit4InitMethodNotRun.findAnnotation(methodTree, state, badAnnotation);
            return this.describeMatch(annotationTree, (Fix)SuggestedFix.builder().addImport(goodAnnotation).replace((Tree)annotationTree, "@" + finalName).build());
        }
        return null;
    }

    private static String getUnqualifiedClassName(String goodAnnotation) {
        return goodAnnotation.substring(goodAnnotation.lastIndexOf(".") + 1);
    }

    private static AnnotationTree findAnnotation(MethodTree methodTree, VisitorState state, String annotationName) {
        AnnotationTree annotationNode = null;
        for (AnnotationTree annotationTree : methodTree.getModifiers().getAnnotations()) {
            if (!ASTHelpers.getSymbol((Tree)annotationTree).equals(state.getSymbolFromString(annotationName))) continue;
            annotationNode = annotationTree;
        }
        return annotationNode;
    }

    protected static class AnnotationReplacements
    implements Serializable {
        private final String goodAnnotation;
        private final String badAnnotation;

        protected AnnotationReplacements(String badAnnotation, String goodAnnotation) {
            this.goodAnnotation = goodAnnotation;
            this.badAnnotation = badAnnotation;
        }
    }
}

