/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.RenamedDataEntry;
import proguard.util.StringFunction;

public class RenamedDataEntryReader
implements DataEntryReader {
    private final StringFunction nameFunction;
    private final DataEntryReader dataEntryReader;
    private final DataEntryReader missingDataEntryReader;

    public RenamedDataEntryReader(StringFunction nameFunction, DataEntryReader dataEntryReader) {
        this(nameFunction, dataEntryReader, null);
    }

    public RenamedDataEntryReader(StringFunction nameFunction, DataEntryReader dataEntryReader, DataEntryReader missingDataEntryReader) {
        this.nameFunction = nameFunction;
        this.dataEntryReader = dataEntryReader;
        this.missingDataEntryReader = missingDataEntryReader;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        String newName;
        String name = dataEntry.getName();
        if (dataEntry.isDirectory() && name.length() > 0) {
            name = name + '/';
        }
        if ((newName = this.nameFunction.transform(name)) != null && newName.length() > 0) {
            if (dataEntry.isDirectory()) {
                newName = newName.substring(0, newName.length() - 1);
            }
            this.dataEntryReader.read(new RenamedDataEntry(dataEntry, newName));
        } else if (this.missingDataEntryReader != null) {
            this.missingDataEntryReader.read(dataEntry);
        }
    }
}

