/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.io.ProgramClassWriter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.FileDataEntry;
import proguard.io.RenamedDataEntry;

public class DataEntryClassWriter
implements ClassVisitor {
    private final DataEntry templateDataEntry;
    private final DataEntryWriter dataEntryWriter;

    public DataEntryClassWriter(DataEntryWriter dataEntryWriter) {
        this(new FileDataEntry(new File(""), new File("")), dataEntryWriter);
    }

    public DataEntryClassWriter(DataEntry templateDataEntry, DataEntryWriter dataEntryWriter) {
        this.templateDataEntry = templateDataEntry;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitProgramClass(ProgramClass programClass) {
        block5: {
            String actualClassName = programClass.getName();
            RenamedDataEntry actualDataEntry = new RenamedDataEntry(this.templateDataEntry, actualClassName + ".class");
            try {
                OutputStream outputStream = this.dataEntryWriter.createOutputStream(actualDataEntry);
                if (outputStream == null) break block5;
                try (DataOutputStream classOutputStream = new DataOutputStream(outputStream);){
                    new ProgramClassWriter(classOutputStream).visitProgramClass(programClass);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Can't write program class [" + actualClassName + "] to [" + actualDataEntry + "] (" + e.getMessage() + ")", e);
            }
        }
    }
}

