/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;

public class MethodFilter
implements MemberVisitor {
    private final MemberVisitor methodMemberVisitor;
    private final MemberVisitor fieldMemberVisitor;

    public MethodFilter(MemberVisitor methodMemberVisitor) {
        this(methodMemberVisitor, null);
    }

    public MethodFilter(MemberVisitor methodMemberVisitor, MemberVisitor fieldMemberVisitor) {
        this.methodMemberVisitor = methodMemberVisitor;
        this.fieldMemberVisitor = fieldMemberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.fieldMemberVisitor != null) {
            this.fieldMemberVisitor.visitProgramField(programClass, programField);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.methodMemberVisitor != null) {
            this.methodMemberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.fieldMemberVisitor != null) {
            this.fieldMemberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.methodMemberVisitor != null) {
            this.methodMemberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }
}

