/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.renderer.core;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StringListWriter
extends Writer {
    private StringBuilder currentLine;
    private final List<String> output;

    public StringListWriter(List<String> output) {
        this.output = output;
        this.currentLine = new StringBuilder();
    }

    @Override
    public void write(@NotNull char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.currentLine.append(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        if (System.lineSeparator().equals(str)) {
            this.newLine();
        } else {
            String[] segments;
            for (String segment : segments = str.split(System.lineSeparator())) {
                this.write(segment, 0, segment.length());
                this.newLine();
            }
        }
    }

    private void newLine() {
        this.output.add(this.currentLine.toString());
        this.currentLine = new StringBuilder();
    }

    public List<String> getOutput() {
        return this.output;
    }

    @Override
    public void flush() throws IOException {
        this.newLine();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

