/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Signature;
import proguard.classfile.util.ClassUtil;

public class FieldSignature
extends Signature {
    private static final Map<Field, FieldSignature> signatureCache = Collections.synchronizedMap(new IdentityHashMap());
    public final String memberName;
    public final String descriptor;

    public FieldSignature(String clazzName, String memberName, String descriptor) {
        super(clazzName, Objects.hash(clazzName, memberName, descriptor));
        this.memberName = memberName;
        this.descriptor = descriptor;
    }

    public FieldSignature(Clazz clazz, Field field) {
        this(clazz.getName(), field.getName(clazz), field.getDescriptor(clazz));
    }

    @Override
    public boolean isIncomplete() {
        return this.className == null || this.memberName == null || this.descriptor == null;
    }

    @Override
    protected String calculateFqn() {
        return String.format("L%s;%s", this.className, this.memberName);
    }

    @Override
    protected String calculatePrettyFqn() {
        String type = this.descriptor == null ? null : ClassUtil.externalShortClassName(ClassUtil.externalType(this.descriptor));
        String shortClazzName = this.className == null ? "?" : ClassUtil.externalShortClassName(ClassUtil.externalClassName(this.className));
        return String.format("%s %s.%s", type, shortClazzName, this.memberName);
    }

    public static FieldSignature computeIfAbsent(Clazz clazz, Field field) {
        return signatureCache.computeIfAbsent(field, f -> new FieldSignature(clazz, field));
    }

    public static void clearCache() {
        signatureCache.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FieldSignature that = (FieldSignature)o;
        return Objects.equals(this.memberName, that.memberName) && Objects.equals(this.descriptor, that.descriptor);
    }
}

