/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;

final class FieldScopeUtil {
    private static final Joiner JOINER = Joiner.on((String)", ");

    static Function<Optional<Descriptors.Descriptor>, String> fieldNumbersFunction(final String fmt, final Iterable<Integer> fieldNumbers) {
        return new Function<Optional<Descriptors.Descriptor>, String>(){

            public String apply(Optional<Descriptors.Descriptor> optDescriptor) {
                return FieldScopeUtil.resolveFieldNumbers((Optional<Descriptors.Descriptor>)optDescriptor, fmt, fieldNumbers);
            }
        };
    }

    static Function<Optional<Descriptors.Descriptor>, String> fieldScopeFunction(final String fmt, final FieldScope fieldScope) {
        return new Function<Optional<Descriptors.Descriptor>, String>(){

            public String apply(Optional<Descriptors.Descriptor> optDescriptor) {
                return String.format(fmt, fieldScope.usingCorrespondenceString(optDescriptor));
            }
        };
    }

    static Function<Optional<Descriptors.Descriptor>, String> concat(final Function<? super Optional<Descriptors.Descriptor>, String> function1, final Function<? super Optional<Descriptors.Descriptor>, String> function2) {
        return new Function<Optional<Descriptors.Descriptor>, String>(){

            public String apply(Optional<Descriptors.Descriptor> optDescriptor) {
                String string = String.valueOf((String)function1.apply(optDescriptor));
                String string2 = String.valueOf((String)function2.apply(optDescriptor));
                return string2.length() != 0 ? string.concat(string2) : new String(string);
            }
        };
    }

    static Optional<Descriptors.Descriptor> getSingleDescriptor(Iterable<? extends Message> messages) {
        Optional optDescriptor = Optional.absent();
        for (Message message : messages) {
            if (message == null) continue;
            Descriptors.Descriptor descriptor = message.getDescriptorForType();
            if (!optDescriptor.isPresent()) {
                optDescriptor = Optional.of((Object)descriptor);
                continue;
            }
            if (descriptor == optDescriptor.get()) continue;
            return Optional.absent();
        }
        return optDescriptor;
    }

    static List<Integer> asList(int first, int ... rest) {
        ArrayList list = Lists.newArrayList();
        list.add(first);
        list.addAll(Ints.asList((int[])rest));
        return list;
    }

    static String join(Iterable<?> objects) {
        return JOINER.join(objects);
    }

    private static String resolveFieldNumbers(Optional<Descriptors.Descriptor> optDescriptor, String fmt, Iterable<Integer> fieldNumbers) {
        if (optDescriptor.isPresent()) {
            Descriptors.Descriptor descriptor = (Descriptors.Descriptor)optDescriptor.get();
            ArrayList strings = Lists.newArrayList();
            for (int fieldNumber : fieldNumbers) {
                Descriptors.FieldDescriptor field = descriptor.findFieldByNumber(fieldNumber);
                strings.add(field != null ? field.toString() : String.format("%d (?)", fieldNumber));
            }
            return String.format(fmt, FieldScopeUtil.join(strings));
        }
        return String.format(fmt, FieldScopeUtil.join(fieldNumbers));
    }

    private FieldScopeUtil() {
    }
}

