/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;

@BugPattern(summary="Methods with ignorable return values (including methods that always 'return this') should be annotated with @com.google.errorprone.annotations.CanIgnoreReturnValue", severity=BugPattern.SeverityLevel.WARNING)
public final class CanIgnoreReturnValueSuggester
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String AUTO_VALUE = "com.google.auto.value.AutoValue";
    private static final String IMMUTABLE = "com.google.errorprone.annotations.Immutable";
    private static final String CIRV = "com.google.errorprone.annotations.CanIgnoreReturnValue";
    private static final ImmutableSet<String> EXEMPTING_METHOD_ANNOTATIONS = ImmutableSet.of((Object)"com.google.errorprone.annotations.CanIgnoreReturnValue", (Object)"com.google.errorprone.annotations.CheckReturnValue", (Object)"com.google.errorprone.refaster.annotation.AfterTemplate");
    private static final Supplier<Type> PROTO_BUILDER = VisitorState.memoize((Supplier & Serializable)s -> s.getTypeFromString("com.google.protobuf.MessageLite.Builder"));
    private static final ImmutableSet<String> BANNED_METHOD_PREFIXES = ImmutableSet.of((Object)"get", (Object)"is", (Object)"has", (Object)"new", (Object)"clone", (Object)"copy", (Object[])new String[0]);
    private final ImmutableSet<String> exemptingMethodAnnotations;

    @Inject
    public CanIgnoreReturnValueSuggester(ErrorProneFlags errorProneFlags) {
        this.exemptingMethodAnnotations = Sets.union(EXEMPTING_METHOD_ANNOTATIONS, (Set)errorProneFlags.getSetOrEmpty("CanIgnoreReturnValue:ExemptingMethodAnnotations")).immutableCopy();
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)methodTree);
        if (this.exemptingMethodAnnotations.stream().anyMatch(annotation -> ASTHelpers.hasAnnotation((Symbol)methodSymbol, (String)annotation, (VisitorState)state))) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.shouldKeep((Tree)methodTree)) {
            return Description.NO_MATCH;
        }
        String methodName = ((Name)methodSymbol.getSimpleName()).toString();
        if (BANNED_METHOD_PREFIXES.stream().anyMatch(methodName::startsWith)) {
            return Description.NO_MATCH;
        }
        if (CanIgnoreReturnValueSuggester.methodAlwaysReturnsInputParam(methodTree, state)) {
            return this.annotateWithCanIgnoreReturnValue(methodTree, state);
        }
        if (methodSymbol.isStatic() || !ASTHelpers.isSameType((Type)methodSymbol.owner.type, (Type)methodSymbol.getReturnType(), (VisitorState)state) || CanIgnoreReturnValueSuggester.isDefinitionOfZeroArgSelf(methodSymbol) || methodTree.getReturnType() == null || CanIgnoreReturnValueSuggester.isSimpleReturnThisMethod(methodTree) || ASTHelpers.isSubtype((Type)methodSymbol.owner.type, (Type)((Type)PROTO_BUILDER.get(state)), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (CanIgnoreReturnValueSuggester.isAbstractAutoValueOrAutoBuilderMethod(methodSymbol, state)) {
            return Description.NO_MATCH;
        }
        if (CanIgnoreReturnValueSuggester.classLooksLikeBuilder(methodSymbol.owner, state) || CanIgnoreReturnValueSuggester.methodReturnsIgnorableValues(methodTree, state)) {
            return this.annotateWithCanIgnoreReturnValue(methodTree, state);
        }
        return Description.NO_MATCH;
    }

    private Description annotateWithCanIgnoreReturnValue(MethodTree methodTree, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        AnnotationTree riuAnnotation = ASTHelpers.getAnnotationWithSimpleName(methodTree.getModifiers().getAnnotations(), (String)"ResultIgnorabilityUnspecified");
        if (riuAnnotation != null) {
            fix.delete((Tree)riuAnnotation);
        }
        fix.prefixWith((Tree)methodTree, "@" + SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)CIRV) + "\n");
        return this.describeMatch(methodTree, (Fix)fix.build());
    }

    private static boolean isAbstractAutoValueOrAutoBuilderMethod(Symbol.MethodSymbol methodSymbol, VisitorState state) {
        Symbol owner = methodSymbol.owner;
        return ASTHelpers.isAbstract((Symbol.MethodSymbol)methodSymbol) && (ASTHelpers.hasAnnotation((Symbol)owner, (String)"com.google.auto.value.AutoValue.Builder", (VisitorState)state) || ASTHelpers.hasAnnotation((Symbol)owner, (String)"com.google.auto.value.AutoBuilder", (VisitorState)state));
    }

    private static boolean classLooksLikeBuilder(Symbol owner, VisitorState state) {
        boolean classIsImmutable = ASTHelpers.hasAnnotation((Symbol)owner, (String)IMMUTABLE, (VisitorState)state) || ASTHelpers.hasAnnotation((Symbol)owner, (String)AUTO_VALUE, (VisitorState)state);
        return owner.getSimpleName().toString().endsWith("Builder") && !classIsImmutable;
    }

    private static boolean isSimpleReturnThisMethod(MethodTree methodTree) {
        StatementTree onlyStatement;
        if (methodTree.getBody() != null && methodTree.getBody().getStatements().size() == 1 && (onlyStatement = methodTree.getBody().getStatements().get(0)) instanceof ReturnTree) {
            return CanIgnoreReturnValueSuggester.returnsThisOrSelf((ReturnTree)onlyStatement);
        }
        return false;
    }

    private static boolean isIdentifier(ExpressionTree expr, String identifierName) {
        if ((expr = ASTHelpers.stripParentheses((ExpressionTree)expr)) instanceof IdentifierTree) {
            return ((IdentifierTree)expr).getName().contentEquals(identifierName);
        }
        return false;
    }

    private static boolean returnsThisOrSelf(ReturnTree returnTree) {
        return CanIgnoreReturnValueSuggester.maybeCastThis(returnTree.getExpression());
    }

    private static boolean maybeCastThis(Tree tree) {
        return (Boolean)MoreObjects.firstNonNull((Object)((Boolean)new SimpleTreeVisitor<Boolean, Void>(){

            @Override
            public Boolean visitParenthesized(ParenthesizedTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), null);
            }

            @Override
            public Boolean visitTypeCast(TypeCastTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), null);
            }

            @Override
            public Boolean visitIdentifier(IdentifierTree tree, Void unused) {
                return tree.getName().contentEquals("this");
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                return ((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).contentEquals("self") || ((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).contentEquals("getThis");
            }
        }.visit(tree, null)), (Object)false);
    }

    private static boolean isDefinitionOfZeroArgSelf(Symbol.MethodSymbol methodSymbol) {
        return (((Name)methodSymbol.getSimpleName()).contentEquals("self") || ((Name)methodSymbol.getSimpleName()).contentEquals("getThis")) && ((List)methodSymbol.getParameters()).isEmpty();
    }

    private static boolean methodReturnsIgnorableValues(MethodTree tree, VisitorState state) {
        class ReturnValuesFromMethodAreIgnorable
        extends TreeScanner<Void, Void> {
            private final VisitorState state;
            private final Type enclosingClassType;
            private final Type methodReturnType;
            private boolean atLeastOneReturn = false;
            private boolean allReturnsIgnorable = true;

            private ReturnValuesFromMethodAreIgnorable(VisitorState state, Symbol.MethodSymbol methSymbol) {
                this.state = state;
                this.methodReturnType = methSymbol.getReturnType();
                this.enclosingClassType = methSymbol.enclClass().type;
            }

            @Override
            public Void visitReturn(ReturnTree returnTree, Void unused) {
                this.atLeastOneReturn = true;
                if (!CanIgnoreReturnValueSuggester.returnsThisOrSelf(returnTree) && !this.isIgnorableMethodCallOnSameInstance(returnTree, this.state)) {
                    this.allReturnsIgnorable = false;
                }
                return null;
            }

            private boolean isIgnorableMethodCallOnSameInstance(ReturnTree returnTree, VisitorState state) {
                if (returnTree.getExpression() instanceof MethodInvocationTree) {
                    MethodInvocationTree mit = (MethodInvocationTree)returnTree.getExpression();
                    ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)mit);
                    Symbol.MethodSymbol calledMethod = ASTHelpers.getSymbol((MethodInvocationTree)mit);
                    if (receiver == null && !calledMethod.isStatic() || CanIgnoreReturnValueSuggester.isIdentifier(receiver, "this") || CanIgnoreReturnValueSuggester.isIdentifier(receiver, "super")) {
                        return ASTHelpers.hasAnnotation((Symbol)calledMethod, (String)CanIgnoreReturnValueSuggester.CIRV, (VisitorState)state) && ASTHelpers.isSubtype((Type)this.enclosingClassType, (Type)this.methodReturnType, (VisitorState)state) && ASTHelpers.isSubtype((Type)this.enclosingClassType, (Type)ASTHelpers.getReturnType((ExpressionTree)mit), (VisitorState)state);
                    }
                }
                return false;
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return null;
            }

            @Override
            public Void visitNewClass(NewClassTree node, Void unused) {
                return null;
            }
        }
        ReturnValuesFromMethodAreIgnorable scanner = new ReturnValuesFromMethodAreIgnorable(state, ASTHelpers.getSymbol((MethodTree)tree));
        scanner.scan(tree, null);
        return scanner.atLeastOneReturn && scanner.allReturnsIgnorable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean methodAlwaysReturnsInputParam(MethodTree methodTree, VisitorState state) {
        if (methodTree.getParameters().isEmpty()) {
            return false;
        }
        class AllReturnsAreInputParams
        extends TreeScanner<Void, Void> {
            private final Set<Symbol> returnedSymbols = new HashSet<Symbol>();

            AllReturnsAreInputParams() {
            }

            @Override
            public Void visitReturn(ReturnTree returnTree, Void unused) {
                this.returnedSymbols.add(ASTHelpers.getSymbol((Tree)ASTHelpers.stripParentheses((ExpressionTree)returnTree.getExpression())));
                return null;
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return null;
            }

            @Override
            public Void visitNewClass(NewClassTree node, Void unused) {
                return null;
            }
        }
        AllReturnsAreInputParams scanner = new AllReturnsAreInputParams();
        scanner.scan(methodTree, null);
        if (scanner.returnedSymbols.size() != 1) {
            return false;
        }
        Symbol returnedSymbol = (Symbol)Iterables.getOnlyElement(scanner.returnedSymbols);
        if (returnedSymbol == null) {
            return false;
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)methodTree);
        if (!ASTHelpers.isSameType((Type)returnedSymbol.type, (Type)methodSymbol.getReturnType(), (VisitorState)state)) return false;
        if (!methodSymbol.getParameters().stream().filter(ASTHelpers::isConsideredFinal).anyMatch(returnedSymbol::equals)) return false;
        return true;
    }
}

