/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.analysis;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.shaded.dataflow.analysis.AbstractAnalysis;
import org.checkerframework.shaded.dataflow.analysis.AbstractValue;
import org.checkerframework.shaded.dataflow.analysis.Analysis;
import org.checkerframework.shaded.dataflow.analysis.BackwardAnalysis;
import org.checkerframework.shaded.dataflow.analysis.BackwardTransferFunction;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.analysis.TransferInput;
import org.checkerframework.shaded.dataflow.analysis.TransferResult;
import org.checkerframework.shaded.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.shaded.dataflow.cfg.UnderlyingAST;
import org.checkerframework.shaded.dataflow.cfg.block.Block;
import org.checkerframework.shaded.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.shaded.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.shaded.dataflow.cfg.block.RegularBlock;
import org.checkerframework.shaded.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.shaded.dataflow.cfg.node.Node;
import org.checkerframework.shaded.dataflow.cfg.node.ReturnNode;
import org.checkerframework.shaded.javacutil.BugInCF;

public class BackwardAnalysisImpl<V extends AbstractValue<V>, S extends Store<S>, T extends BackwardTransferFunction<V, S>>
extends AbstractAnalysis<V, S, T>
implements BackwardAnalysis<V, S, T> {
    protected final IdentityHashMap<Block, S> outStores = new IdentityHashMap();
    protected final IdentityHashMap<ExceptionBlock, S> exceptionStores = new IdentityHashMap();
    protected @Nullable S storeAtEntry = null;

    public BackwardAnalysisImpl() {
        super(Analysis.Direction.BACKWARD);
    }

    public BackwardAnalysisImpl(@Nullable T transfer) {
        this();
        this.transferFunction = transfer;
    }

    @Override
    public void performAnalysis(ControlFlowGraph cfg) {
        if (this.isRunning) {
            throw new BugInCF("performAnalysis() shouldn't be called when the analysis is running.");
        }
        this.isRunning = true;
        try {
            this.init(cfg);
            while (!this.worklist.isEmpty()) {
                Block b = this.worklist.poll();
                this.performAnalysisBlock(b);
            }
        }
        finally {
            assert (this.isRunning);
            this.isRunning = false;
        }
    }

    @Override
    public void performAnalysisBlock(Block b) {
        switch (b.getType()) {
            case REGULAR_BLOCK: {
                RegularBlock rb = (RegularBlock)b;
                TransferInput<V, S> inputAfter = this.getInput(rb);
                assert (inputAfter != null) : "@AssumeAssertion(nullness): invariant";
                this.currentInput = inputAfter.copy();
                Node firstNode = null;
                boolean addToWorklistAgain = false;
                List<Node> nodeList = rb.getNodes();
                ListIterator<Node> reverseIter = nodeList.listIterator(nodeList.size());
                while (reverseIter.hasPrevious()) {
                    Node node = reverseIter.previous();
                    assert (this.currentInput != null) : "@AssumeAssertion(nullness): invariant";
                    TransferResult transferResult = this.callTransferFunction(node, this.currentInput);
                    addToWorklistAgain |= this.updateNodeValues(node, transferResult);
                    this.currentInput = new TransferInput(node, this, transferResult);
                    firstNode = node;
                }
                for (Block pred : rb.getPredecessors()) {
                    assert (this.currentInput != null) : "@AssumeAssertion(nullness): invariant";
                    this.propagateStoresTo(pred, firstNode, this.currentInput, Store.FlowRule.EACH_TO_EACH, addToWorklistAgain);
                }
                break;
            }
            case EXCEPTION_BLOCK: {
                ExceptionBlock eb = (ExceptionBlock)b;
                TransferInput<V, S> inputAfter = this.getInput(eb);
                assert (inputAfter != null) : "@AssumeAssertion(nullness): invariant";
                this.currentInput = inputAfter.copy();
                Node node = eb.getNode();
                TransferResult transferResult = this.callTransferFunction(node, this.currentInput);
                boolean addToWorklistAgain = this.updateNodeValues(node, transferResult);
                Store exceptionStore = (Store)this.exceptionStores.get(eb);
                Object mergedStore = exceptionStore != null ? transferResult.getRegularStore().leastUpperBound((Store)exceptionStore) : transferResult.getRegularStore();
                for (Block pred : eb.getPredecessors()) {
                    this.addStoreAfter(pred, node, mergedStore, addToWorklistAgain);
                }
                break;
            }
            case CONDITIONAL_BLOCK: {
                ConditionalBlock cb = (ConditionalBlock)b;
                TransferInput<V, S> inputAfter = this.getInput(cb);
                assert (inputAfter != null) : "@AssumeAssertion(nullness): invariant";
                TransferInput<V, S> input = inputAfter.copy();
                for (Block pred : cb.getPredecessors()) {
                    this.propagateStoresTo(pred, null, input, Store.FlowRule.EACH_TO_EACH, false);
                }
                break;
            }
            case SPECIAL_BLOCK: {
                SpecialBlock sb = (SpecialBlock)b;
                SpecialBlock.SpecialBlockType sType = sb.getSpecialType();
                if (sType == SpecialBlock.SpecialBlockType.ENTRY) {
                    this.storeAtEntry = (Store)this.outStores.get(sb);
                    break;
                }
                assert (sType == SpecialBlock.SpecialBlockType.EXIT || sType == SpecialBlock.SpecialBlockType.EXCEPTIONAL_EXIT);
                TransferInput<V, S> input = this.getInput(sb);
                assert (input != null) : "@AssumeAssertion(nullness): invariant";
                for (Block pred : sb.getPredecessors()) {
                    this.propagateStoresTo(pred, null, input, Store.FlowRule.EACH_TO_EACH, false);
                }
                break;
            }
            default: {
                throw new BugInCF("Unexpected block type: " + (Object)((Object)b.getType()));
            }
        }
    }

    @Override
    public @Nullable TransferInput<V, S> getInput(Block b) {
        return (TransferInput)this.inputs.get(b);
    }

    @Override
    public @Nullable S getEntryStore() {
        return this.storeAtEntry;
    }

    @Override
    protected void initFields(ControlFlowGraph cfg) {
        super.initFields(cfg);
        this.outStores.clear();
        this.exceptionStores.clear();
        this.storeAtEntry = null;
    }

    @Override
    @RequiresNonNull(value={"cfg"})
    protected void initInitialInputs() {
        this.worklist.process(this.cfg);
        SpecialBlock regularExitBlock = this.cfg.getRegularExitBlock();
        SpecialBlock exceptionExitBlock = this.cfg.getExceptionalExitBlock();
        if (this.worklist.depthFirstOrder.get(regularExitBlock) == null && this.worklist.depthFirstOrder.get(exceptionExitBlock) == null) {
            throw new BugInCF("regularExitBlock and exceptionExitBlock should never both be null at the same time.");
        }
        UnderlyingAST underlyingAST = this.cfg.getUnderlyingAST();
        List<ReturnNode> returnNodes = this.cfg.getReturnNodes();
        assert (this.transferFunction != null) : "@AssumeAssertion(nullness): invariant";
        Object normalInitialStore = ((BackwardTransferFunction)this.transferFunction).initialNormalExitStore(underlyingAST, returnNodes);
        Object exceptionalInitialStore = ((BackwardTransferFunction)this.transferFunction).initialExceptionalExitStore(underlyingAST);
        if (this.worklist.depthFirstOrder.get(regularExitBlock) != null) {
            this.worklist.add(regularExitBlock);
            this.inputs.put(regularExitBlock, new TransferInput(null, this, normalInitialStore));
            this.outStores.put(regularExitBlock, normalInitialStore);
        }
        if (this.worklist.depthFirstOrder.get(exceptionExitBlock) != null) {
            this.worklist.add(exceptionExitBlock);
            this.inputs.put(exceptionExitBlock, new TransferInput(null, this, exceptionalInitialStore));
            this.outStores.put(exceptionExitBlock, exceptionalInitialStore);
        }
        if (this.worklist.isEmpty()) {
            throw new BugInCF("The worklist needs at least one exit block as starting point.");
        }
        if (this.inputs.isEmpty() || this.outStores.isEmpty()) {
            throw new BugInCF("At least one input and one output store are required.");
        }
    }

    @Override
    protected void propagateStoresTo(Block pred, @Nullable Node node, TransferInput<V, S> currentInput, Store.FlowRule flowRule, boolean addToWorklistAgain) {
        if (flowRule != Store.FlowRule.EACH_TO_EACH) {
            throw new BugInCF("Backward analysis always propagates EACH to EACH, because there is no control flow.");
        }
        this.addStoreAfter(pred, node, currentInput.getRegularStore(), addToWorklistAgain);
    }

    protected void addStoreAfter(Block pred, @Nullable Node node, S s2, boolean addBlockToWorklist) {
        if (pred instanceof ExceptionBlock && ((ExceptionBlock)pred).getSuccessor() != null && node != null) {
            @Nullable Block succBlock = ((ExceptionBlock)pred).getSuccessor();
            @Nullable Block block = node.getBlock();
            if (succBlock != null && block != null && succBlock.getUid() == block.getUid()) {
                S newExceptionStore;
                ExceptionBlock ebPred = (ExceptionBlock)pred;
                Store exceptionStore = (Store)this.exceptionStores.get(ebPred);
                S s3 = newExceptionStore = exceptionStore != null ? exceptionStore.leastUpperBound(s2) : s2;
                if (!newExceptionStore.equals(exceptionStore)) {
                    this.exceptionStores.put(ebPred, newExceptionStore);
                    this.inputs.put(ebPred, new TransferInput(node, this, newExceptionStore));
                    addBlockToWorklist = true;
                }
            }
        } else {
            S newPredOutStore;
            S predOutStore = this.getStoreAfter(pred);
            S s4 = newPredOutStore = predOutStore != null ? predOutStore.leastUpperBound(s2) : s2;
            if (!newPredOutStore.equals(predOutStore)) {
                this.outStores.put(pred, newPredOutStore);
                this.inputs.put(pred, new TransferInput(node, this, newPredOutStore));
                addBlockToWorklist = true;
            }
        }
        if (addBlockToWorklist) {
            this.addToWorklist(pred);
        }
    }

    protected @Nullable S getStoreAfter(Block b) {
        return (S)((Store)BackwardAnalysisImpl.readFromStore(this.outStores, b));
    }

    @Override
    public S runAnalysisFor(@FindDistinct Node node, Analysis.BeforeOrAfter preOrPost, TransferInput<V, S> blockTransferInput, IdentityHashMap<Node, V> nodeValues, Map<TransferInput<V, S>, IdentityHashMap<Node, TransferResult<V, S>>> analysisCaches) {
        Block block = node.getBlock();
        assert (block != null) : "@AssumeAssertion(nullness): invariant";
        Node oldCurrentNode = this.currentNode;
        if (this.isRunning) {
            assert (this.currentInput != null) : "@AssumeAssertion(nullness): invariant";
            return this.currentInput.getRegularStore();
        }
        this.isRunning = true;
        try {
            switch (block.getType()) {
                case REGULAR_BLOCK: {
                    RegularBlock rBlock = (RegularBlock)block;
                    TransferInput<V, Object> store = blockTransferInput;
                    List<Node> nodeList = rBlock.getNodes();
                    ListIterator<Node> reverseIter = nodeList.listIterator(nodeList.size());
                    while (reverseIter.hasPrevious()) {
                        Node n = reverseIter.previous();
                        this.setCurrentNode(n);
                        if (n == node && preOrPost == Analysis.BeforeOrAfter.AFTER) {
                            S s2 = store.getRegularStore();
                            return s2;
                        }
                        TransferResult<V, S> transferResult = this.callTransferFunction(n, store.copy());
                        if (n == node) {
                            S s3 = transferResult.getRegularStore();
                            return s3;
                        }
                        store = new TransferInput(n, this, transferResult);
                    }
                    throw new BugInCF("node %s is not in node.getBlock()=%s", node, block);
                }
                case EXCEPTION_BLOCK: {
                    ExceptionBlock eb = (ExceptionBlock)block;
                    if (eb.getNode() != node) {
                        throw new BugInCF("Node should be equal to eb.getNode(). But get: node: " + node + "\teb.getNode(): " + eb.getNode());
                    }
                    if (preOrPost == Analysis.BeforeOrAfter.AFTER) {
                        S store = blockTransferInput.getRegularStore();
                        return store;
                    }
                    this.setCurrentNode(node);
                    TransferResult<V, S> transferResult = this.callTransferFunction(node, blockTransferInput.copy());
                    Store exceptionStore = (Store)this.exceptionStores.get(eb);
                    S s4 = exceptionStore == null ? transferResult.getRegularStore() : transferResult.getRegularStore().leastUpperBound((Store)exceptionStore);
                    return s4;
                }
            }
            throw new BugInCF("Unexpected block type: " + (Object)((Object)block.getType()));
        }
        finally {
            this.setCurrentNode(oldCurrentNode);
            this.isRunning = false;
        }
    }
}

