/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessUtils;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.io.Serializable;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;

@BugPattern(summary="Dereference of an expression with a null branch", severity=BugPattern.SeverityLevel.ERROR)
public final class DereferenceWithNullBranch
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    private static final Supplier<Name> CLASS_KEYWORD = VisitorState.memoize((Supplier & Serializable)state -> state.getName("class"));

    public Description matchMemberSelect(MemberSelectTree select, VisitorState state) {
        if (!DereferenceWithNullBranch.memberSelectExpressionIsATrueExpression(select, state)) {
            return Description.NO_MATCH;
        }
        if (!NullnessUtils.hasDefinitelyNullBranch(select.getExpression(), (Set<Symbol.VarSymbol>)ImmutableSet.of(), (ImmutableSet<Name>)ImmutableSet.of(), state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(select);
    }

    private static boolean memberSelectExpressionIsATrueExpression(MemberSelectTree select, VisitorState state) {
        if (select.getIdentifier().equals(CLASS_KEYWORD.get(state))) {
            return false;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)select.getExpression());
        if (symbol == null) {
            return true;
        }
        return !symbol.getKind().isClass() && !symbol.getKind().isInterface() && symbol.getKind() != ElementKind.PACKAGE;
    }
}

