/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Catch;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.InstanceInitializer;
import lombok.ast.ListAccessor;
import lombok.ast.MethodDeclaration;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.Statement;
import lombok.ast.StaticInitializer;
import lombok.ast.StrictListAccessor;
import lombok.ast.Switch;
import lombok.ast.Synchronized;
import lombok.ast.Try;

public class Block
extends AbstractNode
implements Statement {
    ListAccessor<Statement, Block> contents = ListAccessor.of(this, Statement.class, "Block");

    public MethodDeclaration upToMethodDeclaration() {
        if (!(this.getParent() instanceof MethodDeclaration)) {
            return null;
        }
        MethodDeclaration out = (MethodDeclaration)this.getParent();
        if (out.rawBody() != this) {
            return null;
        }
        return out;
    }

    public Try upIfFinallyToTry() {
        if (!(this.getParent() instanceof Try)) {
            return null;
        }
        Try out = (Try)this.getParent();
        if (out.rawFinally() != this) {
            return null;
        }
        return out;
    }

    public InstanceInitializer upToInstanceInitializer() {
        if (!(this.getParent() instanceof InstanceInitializer)) {
            return null;
        }
        InstanceInitializer out = (InstanceInitializer)this.getParent();
        if (out.rawBody() != this) {
            return null;
        }
        return out;
    }

    public Synchronized upToSynchronized() {
        if (!(this.getParent() instanceof Synchronized)) {
            return null;
        }
        Synchronized out = (Synchronized)this.getParent();
        if (out.rawBody() != this) {
            return null;
        }
        return out;
    }

    public Try upIfTryBodyToTry() {
        if (!(this.getParent() instanceof Try)) {
            return null;
        }
        Try out = (Try)this.getParent();
        if (out.rawBody() != this) {
            return null;
        }
        return out;
    }

    public ConstructorDeclaration upToConstructorDeclaration() {
        if (!(this.getParent() instanceof ConstructorDeclaration)) {
            return null;
        }
        ConstructorDeclaration out = (ConstructorDeclaration)this.getParent();
        if (out.rawBody() != this) {
            return null;
        }
        return out;
    }

    public Catch upToCatch() {
        if (!(this.getParent() instanceof Catch)) {
            return null;
        }
        Catch out = (Catch)this.getParent();
        if (out.rawBody() != this) {
            return null;
        }
        return out;
    }

    public StaticInitializer upToStaticInitializer() {
        if (!(this.getParent() instanceof StaticInitializer)) {
            return null;
        }
        StaticInitializer out = (StaticInitializer)this.getParent();
        if (out.rawBody() != this) {
            return null;
        }
        return out;
    }

    public Switch upToSwitch() {
        if (!(this.getParent() instanceof Switch)) {
            return null;
        }
        Switch out = (Switch)this.getParent();
        if (out.rawBody() != this) {
            return null;
        }
        return out;
    }

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public RawListAccessor<Statement, Block> rawContents() {
        return this.contents.asRaw();
    }

    public StrictListAccessor<Statement, Block> astContents() {
        return this.contents.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.contents.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        return this.rawContents().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        return this.rawContents().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitBlock(this)) {
            return;
        }
        for (AbstractNode child : this.contents.asIterable()) {
            child.accept(visitor);
        }
        visitor.afterVisitBlock(this);
        visitor.endVisit(this);
    }

    @Override
    public Block copy() {
        Block result = new Block();
        for (AbstractNode n : this.contents.backingList()) {
            result.rawContents().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }
}

