/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.io.ByteArrayDataInput;
import com.google.turbine.bytecode.ByteReader;
import com.google.turbine.model.Const;

public class ConstantPoolReader {
    static final int CONSTANT_CLASS = 7;
    static final int CONSTANT_FIELDREF = 9;
    static final int CONSTANT_METHODREF = 10;
    static final int CONSTANT_INTERFACE_METHODREF = 11;
    static final int CONSTANT_STRING = 8;
    static final int CONSTANT_INTEGER = 3;
    static final int CONSTANT_FLOAT = 4;
    static final int CONSTANT_LONG = 5;
    static final int CONSTANT_DOUBLE = 6;
    static final int CONSTANT_NAME_AND_TYPE = 12;
    static final int CONSTANT_UTF8 = 1;
    static final int CONSTANT_METHOD_HANDLE = 15;
    static final int CONSTANT_METHOD_TYPE = 16;
    static final int CONSTANT_DYNAMIC = 17;
    static final int CONSTANT_INVOKE_DYNAMIC = 18;
    static final int CONSTANT_MODULE = 19;
    static final int CONSTANT_PACKAGE = 20;
    private final int[] constantPool;
    private final ByteReader byteReader;

    private ConstantPoolReader(int[] constantPool, ByteReader byteReader) {
        this.constantPool = constantPool;
        this.byteReader = byteReader;
    }

    public static ConstantPoolReader readConstantPool(ByteReader reader) {
        int constantPoolCount = reader.u2();
        int[] constantPool = new int[constantPoolCount - 1];
        for (int i = 0; i < constantPoolCount - 1; i += ConstantPoolReader.skipConstantPool(reader)) {
            constantPool[i] = reader.pos();
        }
        return new ConstantPoolReader(constantPool, reader);
    }

    private static int skipConstantPool(ByteReader reader) {
        int tag = reader.u1();
        switch (tag) {
            case 7: 
            case 8: 
            case 16: 
            case 19: 
            case 20: {
                reader.skip(2);
                return 1;
            }
            case 5: 
            case 6: {
                reader.skip(8);
                return 2;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: {
                reader.skip(4);
                return 1;
            }
            case 1: {
                reader.skip(reader.u2());
                return 1;
            }
            case 15: {
                reader.skip(3);
                return 1;
            }
        }
        throw new AssertionError((Object)String.format("bad constant pool tag: 0x%x", tag));
    }

    public String classInfo(int index) {
        ByteArrayDataInput reader = this.byteReader.seek(this.constantPool[index - 1]);
        byte tag = reader.readByte();
        if (tag != 7) {
            throw new AssertionError((Object)String.format("bad tag: %x", tag));
        }
        int nameIndex = reader.readUnsignedShort();
        return this.utf8(nameIndex);
    }

    public String utf8(int index) {
        ByteArrayDataInput reader = this.byteReader.seek(this.constantPool[index - 1]);
        byte tag = reader.readByte();
        if (tag != 1) {
            throw new AssertionError((Object)String.format("bad tag: %x", tag));
        }
        return reader.readUTF();
    }

    public String moduleInfo(int index) {
        ByteArrayDataInput reader = this.byteReader.seek(this.constantPool[index - 1]);
        byte tag = reader.readByte();
        if (tag != 19) {
            throw new AssertionError((Object)String.format("bad tag: %x", tag));
        }
        int nameIndex = reader.readUnsignedShort();
        return this.utf8(nameIndex);
    }

    public String packageInfo(int index) {
        ByteArrayDataInput reader = this.byteReader.seek(this.constantPool[index - 1]);
        byte tag = reader.readByte();
        if (tag != 20) {
            throw new AssertionError((Object)String.format("bad tag: %x", tag));
        }
        int nameIndex = reader.readUnsignedShort();
        return this.utf8(nameIndex);
    }

    Const.Value constant(int index) {
        ByteArrayDataInput reader = this.byteReader.seek(this.constantPool[index - 1]);
        byte tag = reader.readByte();
        switch (tag) {
            case 5: {
                return new Const.LongValue(reader.readLong());
            }
            case 4: {
                return new Const.FloatValue(reader.readFloat());
            }
            case 6: {
                return new Const.DoubleValue(reader.readDouble());
            }
            case 3: {
                return new Const.IntValue(reader.readInt());
            }
            case 8: {
                return new Const.StringValue(this.utf8(reader.readUnsignedShort()));
            }
            case 1: {
                return new Const.StringValue(reader.readUTF());
            }
        }
        throw new AssertionError((Object)String.format("bad tag: %x", tag));
    }
}

