/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.Fact;
import com.google.common.truth.Facts;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Ordered;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class MapSubject
extends Subject {
    private final Map<?, ?> actual;
    private static final ValueTester<Object, Object> EQUALITY = new ValueTester<Object, Object>(){

        @Override
        public boolean test(@NullableDecl Object actualValue, @NullableDecl Object expectedValue) {
            return Objects.equal((Object)actualValue, (Object)expectedValue);
        }
    };
    private static final Function<ValueDifference<Object, Object>, String> VALUE_DIFFERENCE_FORMAT = new Function<ValueDifference<Object, Object>, String>(){

        public String apply(ValueDifference<Object, Object> values) {
            boolean includeTypes = String.valueOf(((ValueDifference)values).actual).equals(String.valueOf(((ValueDifference)values).expected));
            return Strings.lenientFormat((String)"(expected %s but got %s)", (Object[])new Object[]{includeTypes ? new TypedToStringWrapper(((ValueDifference)values).expected) : ((ValueDifference)values).expected, includeTypes ? new TypedToStringWrapper(((ValueDifference)values).actual) : ((ValueDifference)values).actual});
        }
    };
    private static final Ordered IN_ORDER = new Ordered(){

        @Override
        public void inOrder() {
        }
    };
    private static final Ordered ALREADY_FAILED = new Ordered(){

        @Override
        public void inOrder() {
        }
    };

    protected MapSubject(FailureMetadata metadata, @NullableDecl Map<?, ?> map) {
        super(metadata, map);
        this.actual = map;
    }

    @Override
    public final void isEqualTo(@NullableDecl Object other) {
        if (Objects.equal(this.actual, (Object)other)) {
            return;
        }
        if (this.actual == null || !(other instanceof Map)) {
            super.isEqualTo(other);
            return;
        }
        this.containsEntriesInAnyOrder((Map)other, "is equal to", false);
    }

    public final void isEmpty() {
        if (!this.actual.isEmpty()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public final void isNotEmpty() {
        if (this.actual.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize (%s) must be >= 0", (int)expectedSize);
        this.check("size()", new Object[0]).that(this.actual.size()).isEqualTo(expectedSize);
    }

    public final void containsKey(@NullableDecl Object key) {
        this.check("keySet()", new Object[0]).that(this.actual.keySet()).contains(key);
    }

    public final void doesNotContainKey(@NullableDecl Object key) {
        this.check("keySet()", new Object[0]).that(this.actual.keySet()).doesNotContain(key);
    }

    public final void containsEntry(@NullableDecl Object key, @NullableDecl Object value) {
        Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
        if (!this.actual.entrySet().contains(entry)) {
            ArrayList keyList = Lists.newArrayList((Object[])new Object[]{key});
            ArrayList valueList = Lists.newArrayList((Object[])new Object[]{value});
            if (SubjectUtils.hasMatchingToStringPair(this.actual.keySet(), keyList)) {
                this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat((String)"Not true that <%s> contains entry <%s (%s)>. However, it does contain keys <%s>.", (Object[])new Object[]{this.actualCustomStringRepresentationForPackageMembersToCall(), entry, SubjectUtils.objectToTypeName(entry), SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual.keySet(), keyList))})), new Fact[0]);
            } else if (SubjectUtils.hasMatchingToStringPair(this.actual.values(), valueList)) {
                this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat((String)"Not true that <%s> contains entry <%s (%s)>. However, it does contain values <%s>.", (Object[])new Object[]{this.actualCustomStringRepresentationForPackageMembersToCall(), entry, SubjectUtils.objectToTypeName(entry), SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual.values(), valueList))})), new Fact[0]);
            } else if (this.actual.containsKey(key)) {
                Object actualValue = this.actual.get(key);
                StandardSubjectBuilder check = this.check("get(%s)", key);
                if (value == null || actualValue == null) {
                    check = check.withMessage("key is present but with a different value");
                }
                check.that(actualValue).failEqualityCheckForEqualsWithoutDescription(value);
            } else if (this.actual.containsValue(value)) {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry<?, ?> actualEntry : this.actual.entrySet()) {
                    if (!Objects.equal(actualEntry.getValue(), (Object)value)) continue;
                    keys.add(actualEntry.getKey());
                }
                this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat((String)"Not true that <%s> contains entry <%s>. However, the following keys are mapped to <%s>: %s", (Object[])new Object[]{this.actualCustomStringRepresentationForPackageMembersToCall(), entry, value, keys})), new Fact[0]);
            } else {
                this.failWithActual("expected to contain entry", entry);
            }
        }
    }

    public final void doesNotContainEntry(@NullableDecl Object key, @NullableDecl Object value) {
        this.checkNoNeedToDisplayBothValues("entrySet()", new Object[0]).that(this.actual.entrySet()).doesNotContain(Maps.immutableEntry((Object)key, (Object)value));
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly() {
        return this.containsExactlyEntriesIn((Map<?, ?>)ImmutableMap.of());
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly(@NullableDecl Object k0, @NullableDecl Object v0, Object ... rest) {
        return this.containsExactlyEntriesIn(MapSubject.accumulateMap("containsExactly", k0, v0, rest));
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeast(@NullableDecl Object k0, @NullableDecl Object v0, Object ... rest) {
        return this.containsAtLeastEntriesIn(MapSubject.accumulateMap("containsAtLeast", k0, v0, rest));
    }

    private static Map<Object, Object> accumulateMap(String functionName, @NullableDecl Object k0, @NullableDecl Object v0, Object ... rest) {
        Preconditions.checkArgument((rest.length % 2 == 0 ? 1 : 0) != 0, (String)"There must be an equal number of key/value pairs (i.e., the number of key/value parameters (%s) must be even).", (int)(rest.length + 2));
        LinkedHashMap expectedMap = Maps.newLinkedHashMap();
        expectedMap.put(k0, v0);
        LinkedHashMultiset keys = LinkedHashMultiset.create();
        keys.add(k0);
        for (int i = 0; i < rest.length; i += 2) {
            Object key = rest[i];
            expectedMap.put(key, rest[i + 1]);
            keys.add(key);
        }
        Preconditions.checkArgument((keys.size() == expectedMap.size() ? 1 : 0) != 0, (String)"Duplicate keys (%s) cannot be passed to %s().", (Object)keys, (Object)functionName);
        return expectedMap;
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyEntriesIn(Map<?, ?> expectedMap) {
        if (expectedMap.isEmpty()) {
            if (this.actual.isEmpty()) {
                return IN_ORDER;
            }
            this.isEmpty();
            return ALREADY_FAILED;
        }
        boolean containsAnyOrder = this.containsEntriesInAnyOrder(expectedMap, "contains exactly", false);
        if (containsAnyOrder) {
            return new MapInOrder(expectedMap, "contains exactly these entries in order");
        }
        return ALREADY_FAILED;
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeastEntriesIn(Map<?, ?> expectedMap) {
        if (expectedMap.isEmpty()) {
            return IN_ORDER;
        }
        boolean containsAnyOrder = this.containsEntriesInAnyOrder(expectedMap, "contains at least", true);
        if (containsAnyOrder) {
            return new MapInOrder(expectedMap, "contains at least these entries in order");
        }
        return ALREADY_FAILED;
    }

    @CanIgnoreReturnValue
    private boolean containsEntriesInAnyOrder(Map<?, ?> expectedMap, String failVerb, boolean allowUnexpected) {
        MapDifference<?, Object, Object> diff = MapDifference.create(this.actual, expectedMap, allowUnexpected, EQUALITY);
        if (diff.isEmpty()) {
            return true;
        }
        this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat((String)"Not true that <%s> %s <%s>. It %s", (Object[])new Object[]{this.actualCustomStringRepresentationForPackageMembersToCall(), failVerb, expectedMap, diff.describe(VALUE_DIFFERENCE_FORMAT)})), new Fact[0]);
        return false;
    }

    private static final Map<Object, Object> addKeyTypes(Map<?, ?> in) {
        LinkedHashMap out = Maps.newLinkedHashMap();
        for (Map.Entry<?, ?> entry : in.entrySet()) {
            out.put(new TypedToStringWrapper(entry.getKey()), entry.getValue());
        }
        return out;
    }

    public final <A, E> UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<? super A, ? super E> correspondence) {
        return new UsingCorrespondence(correspondence);
    }

    public final class UsingCorrespondence<A, E> {
        private final Correspondence<? super A, ? super E> correspondence;

        private UsingCorrespondence(Correspondence<? super A, ? super E> correspondence) {
            this.correspondence = (Correspondence)Preconditions.checkNotNull(correspondence);
        }

        public void containsEntry(@NullableDecl Object expectedKey, @NullableDecl E expectedValue) {
            if (MapSubject.this.actual.containsKey(expectedKey)) {
                Correspondence.ExceptionStore exceptions;
                A actualValue = this.getCastSubject().get(expectedKey);
                if (this.correspondence.safeCompare(actualValue, expectedValue, exceptions = Correspondence.ExceptionStore.forMapValues())) {
                    return;
                }
                String diff = this.correspondence.safeFormatDiff(actualValue, expectedValue, exceptions);
                if (diff != null) {
                    MapSubject.this.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat((String)"Not true that <%s> contains an entry with key <%s> and a value that %s <%s>. However, it has a mapping from that key to <%s> (diff: %s)", (Object[])new Object[]{MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), expectedKey, this.correspondence, expectedValue, actualValue, diff}))).and(exceptions.describeAsAdditionalInfo()));
                } else {
                    MapSubject.this.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat((String)"Not true that <%s> contains an entry with key <%s> and a value that %s <%s>. However, it has a mapping from that key to <%s>", (Object[])new Object[]{MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), expectedKey, this.correspondence, expectedValue, actualValue}))).and(exceptions.describeAsAdditionalInfo()));
                }
            } else {
                LinkedHashSet keys = new LinkedHashSet();
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (Map.Entry<?, A> actualEntry : this.getCastSubject().entrySet()) {
                    if (!this.correspondence.safeCompare(actualEntry.getValue(), expectedValue, exceptions)) continue;
                    keys.add(actualEntry.getKey());
                }
                if (!keys.isEmpty()) {
                    MapSubject.this.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat((String)"Not true that <%s> contains an entry with key <%s> and a value that %s <%s>. However, the following keys are mapped to such values: <%s>", (Object[])new Object[]{MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), expectedKey, this.correspondence, expectedValue, keys}))).and(exceptions.describeAsAdditionalInfo()));
                } else {
                    MapSubject.this.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat((String)"Not true that <%s> contains an entry with key <%s> and a value that %s <%s>", (Object[])new Object[]{MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), expectedKey, this.correspondence, expectedValue}))).and(exceptions.describeAsAdditionalInfo()));
                }
            }
        }

        public void doesNotContainEntry(@NullableDecl Object excludedKey, @NullableDecl E excludedValue) {
            if (MapSubject.this.actual.containsKey(excludedKey)) {
                Correspondence.ExceptionStore exceptions;
                A actualValue = this.getCastSubject().get(excludedKey);
                if (this.correspondence.safeCompare(actualValue, excludedValue, exceptions = Correspondence.ExceptionStore.forMapValues())) {
                    MapSubject.this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat((String)"Not true that <%s> does not contain an entry with key <%s> and a value that %s <%s>. It maps that key to <%s>", (Object[])new Object[]{MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), excludedKey, this.correspondence, excludedValue, actualValue})), new Fact[0]);
                }
                if (exceptions.hasCompareException()) {
                    MapSubject.this.failWithActual(exceptions.describeAsMainCause().and(Fact.simpleFact("comparing contents by testing that no entry had the forbidden key and a value that " + this.correspondence + " the forbidden value"), Fact.fact("forbidden key", excludedKey), Fact.fact("forbidden value", excludedValue)));
                }
            }
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(@NullableDecl Object k0, @NullableDecl E v0, Object ... rest) {
            Map expectedMap = MapSubject.accumulateMap("containsExactly", k0, v0, rest);
            return this.containsExactlyEntriesIn(expectedMap);
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeast(@NullableDecl Object k0, @NullableDecl E v0, Object ... rest) {
            Map expectedMap = MapSubject.accumulateMap("containsAtLeast", k0, v0, rest);
            return this.containsAtLeastEntriesIn(expectedMap);
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyEntriesIn(Map<?, ? extends E> expectedMap) {
            if (expectedMap.isEmpty()) {
                if (MapSubject.this.actual.isEmpty()) {
                    return IN_ORDER;
                }
                MapSubject.this.isEmpty();
                return ALREADY_FAILED;
            }
            return this.internalContainsEntriesIn("exactly", expectedMap, false);
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeastEntriesIn(Map<?, ? extends E> expectedMap) {
            if (expectedMap.isEmpty()) {
                return IN_ORDER;
            }
            return this.internalContainsEntriesIn("at least", expectedMap, true);
        }

        private <K, V extends E> Ordered internalContainsEntriesIn(String modifier, Map<K, V> expectedMap, boolean allowUnexpected) {
            final Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
            MapDifference<?, A, V> diff = MapDifference.create(this.getCastSubject(), expectedMap, allowUnexpected, new ValueTester<A, E>(){

                @Override
                public boolean test(A actualValue, E expectedValue) {
                    return UsingCorrespondence.this.correspondence.safeCompare(actualValue, expectedValue, exceptions);
                }
            });
            if (diff.isEmpty()) {
                return new MapInOrder(expectedMap, Strings.lenientFormat((String)"contains, in order, %s one entry that has a key that is equal to and a value that %s the key and value of each entry of", (Object[])new Object[]{modifier, this.correspondence}));
            }
            MapSubject.this.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat((String)"Not true that <%s> contains %s one entry that has a key that is equal to and a value that %s the key and value of each entry of <%s>. It %s", (Object[])new Object[]{MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), modifier, this.correspondence, expectedMap, diff.describe(this.valueDiffFormat(exceptions))}))).and(exceptions.describeAsAdditionalInfo()));
            return ALREADY_FAILED;
        }

        private final <V extends E> Function<ValueDifference<A, V>, String> valueDiffFormat(final Correspondence.ExceptionStore exceptions) {
            return new Function<ValueDifference<A, V>, String>(){

                public String apply(ValueDifference<A, V> values) {
                    String diffString = UsingCorrespondence.this.correspondence.safeFormatDiff(values.actual, values.expected, exceptions);
                    if (diffString != null) {
                        return Strings.lenientFormat((String)"(expected %s but got %s, diff: %s)", (Object[])new Object[]{values.expected, values.actual, diffString});
                    }
                    return Strings.lenientFormat((String)"(expected %s but got %s)", (Object[])new Object[]{values.expected, values.actual});
                }
            };
        }

        private Map<?, A> getCastSubject() {
            return MapSubject.this.actual;
        }
    }

    private class MapInOrder
    implements Ordered {
        private final Map<?, ?> expectedMap;
        private final String failVerb;

        MapInOrder(Map<?, ?> expectedMap, String failVerb) {
            this.expectedMap = expectedMap;
            this.failVerb = failVerb;
        }

        @Override
        public void inOrder() {
            ArrayList expectedKeyOrder = Lists.newArrayList((Iterable)Sets.intersection(this.expectedMap.keySet(), MapSubject.this.actual.keySet()));
            ArrayList actualKeyOrder = Lists.newArrayList((Iterable)Sets.intersection(MapSubject.this.actual.keySet(), this.expectedMap.keySet()));
            if (!actualKeyOrder.equals(expectedKeyOrder)) {
                MapSubject.this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat((String)"Not true that <%s> %s <%s>", (Object[])new Object[]{MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), this.failVerb, this.expectedMap})), new Fact[0]);
            }
        }
    }

    private static class TypedToStringWrapper {
        private final Object delegate;

        TypedToStringWrapper(Object delegate) {
            this.delegate = delegate;
        }

        public boolean equals(Object other) {
            return Objects.equal((Object)this.delegate, (Object)other);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.delegate});
        }

        public String toString() {
            return Strings.lenientFormat((String)"%s (%s)", (Object[])new Object[]{this.delegate, SubjectUtils.objectToTypeName(this.delegate)});
        }
    }

    private static class ValueDifference<A, E> {
        private final A actual;
        private final E expected;

        ValueDifference(@NullableDecl A actual, @NullableDecl E expected) {
            this.actual = actual;
            this.expected = expected;
        }
    }

    private static class MapDifference<K, A, E> {
        private final Map<K, E> missing;
        private final Map<K, A> unexpected;
        private final Map<K, ValueDifference<A, E>> wrongValues;
        private final Set<K> allKeys;

        static <K, A, E> MapDifference<K, A, E> create(Map<? extends K, ? extends A> actual, Map<? extends K, ? extends E> expected, boolean allowUnexpected, ValueTester<? super A, ? super E> valueTester) {
            LinkedHashMap<K, A> unexpected = new LinkedHashMap<K, A>(actual);
            LinkedHashMap<K, E> missing = new LinkedHashMap<K, E>();
            LinkedHashMap wrongValues = new LinkedHashMap();
            for (Map.Entry<K, E> expectedEntry : expected.entrySet()) {
                K expectedKey = expectedEntry.getKey();
                E expectedValue = expectedEntry.getValue();
                if (actual.containsKey(expectedKey)) {
                    Object actualValue = unexpected.remove(expectedKey);
                    if (valueTester.test(actualValue, expectedValue)) continue;
                    wrongValues.put(expectedKey, new ValueDifference(actualValue, expectedValue));
                    continue;
                }
                missing.put(expectedKey, expectedValue);
            }
            if (allowUnexpected) {
                unexpected.clear();
            }
            return new MapDifference(missing, unexpected, wrongValues, Sets.union(actual.keySet(), expected.keySet()));
        }

        private MapDifference(Map<K, E> missing, Map<K, A> unexpected, Map<K, ValueDifference<A, E>> wrongValues, Set<K> allKeys) {
            this.missing = missing;
            this.unexpected = unexpected;
            this.wrongValues = wrongValues;
            this.allKeys = allKeys;
        }

        boolean isEmpty() {
            return this.missing.isEmpty() && this.unexpected.isEmpty() && this.wrongValues.isEmpty();
        }

        String describe(Function<ValueDifference<A, E>, String> valueDiffFormat) {
            boolean includeKeyTypes = this.includeKeyTypes();
            StringBuilder description = new StringBuilder();
            if (!this.missing.isEmpty()) {
                description.append("is missing keys for the following entries: ").append(includeKeyTypes ? MapSubject.addKeyTypes(this.missing) : this.missing);
            }
            if (!this.unexpected.isEmpty()) {
                if (description.length() > 0) {
                    description.append(" and ");
                }
                description.append("has the following entries with unexpected keys: ").append(includeKeyTypes ? MapSubject.addKeyTypes(this.unexpected) : this.unexpected);
            }
            if (!this.wrongValues.isEmpty()) {
                if (description.length() > 0) {
                    description.append(" and ");
                }
                Map wrongValuesFormatted = Maps.transformValues(this.wrongValues, valueDiffFormat);
                description.append("has the following entries with matching keys but different values: ").append(includeKeyTypes ? MapSubject.addKeyTypes(wrongValuesFormatted) : wrongValuesFormatted);
            }
            return description.toString();
        }

        private boolean includeKeyTypes() {
            HashSet keys = Sets.newHashSet();
            keys.addAll(this.missing.keySet());
            keys.addAll(this.unexpected.keySet());
            keys.addAll(this.wrongValues.keySet());
            return SubjectUtils.hasMatchingToStringPair(keys, this.allKeys);
        }
    }

    private static interface ValueTester<A, E> {
        public boolean test(@NullableDecl A var1, @NullableDecl E var2);
    }
}

