/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUseRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public final class ResultUsePolicyEvaluator<C, S, M extends S> {
    private final ImmutableListMultimap<ResultUseRule.RuleScope, ResultUseRule<C, S>> rules;
    private final MethodInfo<C, S, M> methodInfo;

    public static <C, S, M extends S> Builder<C, S, M> builder(MethodInfo<C, S, M> methodInfo) {
        return new Builder<C, S, M>(methodInfo);
    }

    private ResultUsePolicyEvaluator(Builder<C, S, M> builder) {
        this.rules = (ImmutableListMultimap)builder.rules.stream().flatMap(rule -> rule.scopes().stream().map(scope -> Map.entry(scope, rule))).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
        this.methodInfo = builder.methodInfo;
    }

    public ResultUsePolicy evaluate(M method, C state) {
        return this.evaluateAcrossScopes(method, state, (rule, scope, symbol, context) -> rule.evaluate(symbol, context)).findFirst().orElse(ResultUsePolicy.UNSPECIFIED);
    }

    public Stream<ResultUseRule.Evaluation<S>> evaluations(M method, C state) {
        return this.evaluateAcrossScopes(method, state, ResultUseRule::evaluate);
    }

    private <R> Stream<R> evaluateAcrossScopes(M method, C state, ScopeEvaluator<C, S, R> scopeEvaluator) {
        return this.methodInfo.scopes(method).stream().flatMap(scope -> this.evaluateForScope(method, state, scopeEvaluator, (ResultUseRule.RuleScope)((Object)scope)));
    }

    private <R> Stream<R> evaluateForScope(M method, C state, ScopeEvaluator<C, S, R> scopeEvaluator, ResultUseRule.RuleScope scope) {
        ImmutableList scopeRules = this.rules.get((Object)scope);
        return this.methodInfo.scopeMembers(scope, method, state).flatMap(symbol -> scopeRules.stream().map(rule -> scopeEvaluator.evaluateForScope((ResultUseRule)rule, scope, (Object)symbol, state))).flatMap(Optional::stream);
    }

    public static final class Builder<C, S, M extends S> {
        private final List<ResultUseRule<C, S>> rules = new ArrayList<ResultUseRule<C, S>>();
        private final MethodInfo<C, S, M> methodInfo;

        private Builder(MethodInfo<C, S, M> methodInfo) {
            this.methodInfo = methodInfo;
        }

        @CanIgnoreReturnValue
        public Builder<C, S, M> addRule(ResultUseRule<C, S> rule) {
            this.rules.add(rule);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<C, S, M> addRules(ResultUseRule<C, S> ... rules) {
            return this.addRules(Arrays.asList(rules));
        }

        @CanIgnoreReturnValue
        public Builder<C, S, M> addRules(Iterable<? extends ResultUseRule<C, S>> rules) {
            rules.forEach(this::addRule);
            return this;
        }

        public ResultUsePolicyEvaluator<C, S, M> build() {
            return new ResultUsePolicyEvaluator(this);
        }
    }

    public static interface MethodInfo<C, S, M extends S> {
        public Stream<S> scopeMembers(ResultUseRule.RuleScope var1, M var2, C var3);

        public MethodKind getMethodKind(M var1);

        default public ImmutableList<ResultUseRule.RuleScope> scopes(M method) {
            return this.getMethodKind(method).scopes;
        }

        public static enum MethodKind {
            METHOD(ResultUseRule.RuleScope.METHOD, ResultUseRule.RuleScope.ENCLOSING_ELEMENTS, ResultUseRule.RuleScope.GLOBAL),
            CONSTRUCTOR(ResultUseRule.RuleScope.METHOD, ResultUseRule.RuleScope.ENCLOSING_ELEMENTS, ResultUseRule.RuleScope.GLOBAL),
            OTHER(new ResultUseRule.RuleScope[0]);

            private final ImmutableList<ResultUseRule.RuleScope> scopes;

            private MethodKind(ResultUseRule.RuleScope ... scopes) {
                this.scopes = ImmutableList.copyOf((Object[])scopes);
            }
        }
    }

    @FunctionalInterface
    private static interface ScopeEvaluator<C, S, R> {
        public Optional<R> evaluateForScope(ResultUseRule<C, S> var1, ResultUseRule.RuleScope var2, S var3, C var4);
    }
}

