/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Conversion from long to double may lose precision; use an explicit cast to double if this was intentional", severity=BugPattern.SeverityLevel.WARNING)
public final class LongDoubleConversion
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        for (ExpressionTree expressionTree : tree.getArguments()) {
            this.checkArgument(expressionTree, state);
        }
        return Description.NO_MATCH;
    }

    private void checkArgument(ExpressionTree argument, VisitorState state) {
        if (!ASTHelpers.getType((Tree)argument).getKind().equals((Object)TypeKind.LONG)) {
            return;
        }
        Object constant = ASTHelpers.constValue((Tree)argument);
        if (constant instanceof Long && constant.equals((long)((Long)constant).doubleValue())) {
            return;
        }
        ASTHelpers.TargetType targetType = ASTHelpers.targetType((VisitorState)state.withPath(new TreePath(state.getPath(), argument)));
        if (targetType != null && targetType.type().getKind().equals((Object)TypeKind.DOUBLE)) {
            String replacement = SuggestedFixes.castTree((ExpressionTree)argument, (String)"double", (VisitorState)state);
            state.reportMatch(this.describeMatch(argument, (Fix)SuggestedFix.replace((Tree)argument, (String)replacement)));
        }
    }
}

