/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.extensions.proto.AutoValue_FieldScopeLogicMap_Entry;
import com.google.common.truth.extensions.proto.FieldDescriptorOrUnknown;
import com.google.common.truth.extensions.proto.FieldDescriptorValidator;
import com.google.common.truth.extensions.proto.FieldScopeLogic;
import com.google.common.truth.extensions.proto.FieldScopeLogicContainer;
import com.google.protobuf.Descriptors;

class FieldScopeLogicMap<V>
implements FieldScopeLogicContainer<FieldScopeLogicMap<V>> {
    private static final FieldScopeLogicMap<Object> EMPTY_INSTANCE = new FieldScopeLogicMap(ImmutableList.of());
    private final ImmutableList<Entry<V>> entries;

    private FieldScopeLogicMap(Iterable<Entry<V>> entries) {
        this.entries = ImmutableList.copyOf(entries);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public Optional<V> get(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
        for (Entry entry : this.entries) {
            if (!entry.fieldScopeLogic().contains(rootDescriptor, fieldDescriptorOrUnknown)) continue;
            return Optional.of(entry.value());
        }
        return Optional.absent();
    }

    public FieldScopeLogicMap<V> with(FieldScopeLogic fieldScopeLogic, V value) {
        ImmutableList.Builder newEntries = ImmutableList.builder();
        newEntries.add(Entry.of(fieldScopeLogic, value));
        newEntries.addAll(this.entries);
        return new FieldScopeLogicMap<V>(newEntries.build());
    }

    @Override
    public FieldScopeLogicMap<V> subScope(Descriptors.Descriptor rootDescriptor, FieldDescriptorOrUnknown fieldDescriptorOrUnknown) {
        ImmutableList.Builder newEntries = ImmutableList.builderWithExpectedSize((int)this.entries.size());
        for (Entry entry : this.entries) {
            newEntries.add(Entry.of(entry.fieldScopeLogic().subScope(rootDescriptor, fieldDescriptorOrUnknown), entry.value()));
        }
        return new FieldScopeLogicMap<V>(newEntries.build());
    }

    @Override
    public void validate(Descriptors.Descriptor rootDescriptor, FieldDescriptorValidator fieldDescriptorValidator) {
        for (Entry entry : this.entries) {
            entry.fieldScopeLogic().validate(rootDescriptor, fieldDescriptorValidator);
        }
    }

    public static <V> FieldScopeLogicMap<V> empty() {
        return EMPTY_INSTANCE;
    }

    public static <V> FieldScopeLogicMap<V> defaultValue(V value) {
        return new FieldScopeLogicMap<V>(ImmutableList.of(Entry.of(FieldScopeLogic.all(), value)));
    }

    @AutoValue
    static abstract class Entry<V> {
        Entry() {
        }

        abstract FieldScopeLogic fieldScopeLogic();

        abstract V value();

        static <V> Entry<V> of(FieldScopeLogic fieldScopeLogic, V value) {
            return new AutoValue_FieldScopeLogicMap_Entry<V>(fieldScopeLogic, value);
        }
    }
}

