/*
 * Decompiled with CFR 0.152.
 */
package org.mockito;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatcher;
import org.mockito.CheckReturnValue;
import org.mockito.internal.matchers.Any;
import org.mockito.internal.matchers.Contains;
import org.mockito.internal.matchers.EndsWith;
import org.mockito.internal.matchers.Equals;
import org.mockito.internal.matchers.InstanceOf;
import org.mockito.internal.matchers.Matches;
import org.mockito.internal.matchers.NotNull;
import org.mockito.internal.matchers.Null;
import org.mockito.internal.matchers.Same;
import org.mockito.internal.matchers.StartsWith;
import org.mockito.internal.matchers.apachecommons.ReflectionEquals;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.util.Primitives;

@CheckReturnValue
public class ArgumentMatchers {
    public static <T> T any() {
        return ArgumentMatchers.anyObject();
    }

    @Deprecated
    public static <T> T anyObject() {
        ArgumentMatchers.reportMatcher(Any.ANY);
        return null;
    }

    public static <T> T any(Class<T> type) {
        ArgumentMatchers.reportMatcher(new InstanceOf.VarArgAware(type, "<any " + type.getCanonicalName() + ">"));
        return Primitives.defaultValue(type);
    }

    public static <T> T isA(Class<T> type) {
        ArgumentMatchers.reportMatcher(new InstanceOf(type));
        return Primitives.defaultValue(type);
    }

    @Deprecated
    public static <T> T anyVararg() {
        T ignored = ArgumentMatchers.any();
        return null;
    }

    public static boolean anyBoolean() {
        ArgumentMatchers.reportMatcher(new InstanceOf(Boolean.class, "<any boolean>"));
        return false;
    }

    public static byte anyByte() {
        ArgumentMatchers.reportMatcher(new InstanceOf(Byte.class, "<any byte>"));
        return 0;
    }

    public static char anyChar() {
        ArgumentMatchers.reportMatcher(new InstanceOf(Character.class, "<any char>"));
        return '\u0000';
    }

    public static int anyInt() {
        ArgumentMatchers.reportMatcher(new InstanceOf(Integer.class, "<any integer>"));
        return 0;
    }

    public static long anyLong() {
        ArgumentMatchers.reportMatcher(new InstanceOf(Long.class, "<any long>"));
        return 0L;
    }

    public static float anyFloat() {
        ArgumentMatchers.reportMatcher(new InstanceOf(Float.class, "<any float>"));
        return 0.0f;
    }

    public static double anyDouble() {
        ArgumentMatchers.reportMatcher(new InstanceOf(Double.class, "<any double>"));
        return 0.0;
    }

    public static short anyShort() {
        ArgumentMatchers.reportMatcher(new InstanceOf(Short.class, "<any short>"));
        return 0;
    }

    public static String anyString() {
        ArgumentMatchers.reportMatcher(new InstanceOf(String.class, "<any string>"));
        return "";
    }

    public static <T> List<T> anyList() {
        ArgumentMatchers.reportMatcher(new InstanceOf(List.class, "<any List>"));
        return new ArrayList(0);
    }

    @Deprecated
    public static <T> List<T> anyListOf(Class<T> clazz) {
        return ArgumentMatchers.anyList();
    }

    public static <T> Set<T> anySet() {
        ArgumentMatchers.reportMatcher(new InstanceOf(Set.class, "<any set>"));
        return new HashSet(0);
    }

    @Deprecated
    public static <T> Set<T> anySetOf(Class<T> clazz) {
        return ArgumentMatchers.anySet();
    }

    public static <K, V> Map<K, V> anyMap() {
        ArgumentMatchers.reportMatcher(new InstanceOf(Map.class, "<any map>"));
        return new HashMap(0);
    }

    @Deprecated
    public static <K, V> Map<K, V> anyMapOf(Class<K> keyClazz, Class<V> valueClazz) {
        return ArgumentMatchers.anyMap();
    }

    public static <T> Collection<T> anyCollection() {
        ArgumentMatchers.reportMatcher(new InstanceOf(Collection.class, "<any collection>"));
        return new ArrayList(0);
    }

    @Deprecated
    public static <T> Collection<T> anyCollectionOf(Class<T> clazz) {
        return ArgumentMatchers.anyCollection();
    }

    public static <T> Iterable<T> anyIterable() {
        ArgumentMatchers.reportMatcher(new InstanceOf(Iterable.class, "<any iterable>"));
        return new ArrayList(0);
    }

    @Deprecated
    public static <T> Iterable<T> anyIterableOf(Class<T> clazz) {
        return ArgumentMatchers.anyIterable();
    }

    public static boolean eq(boolean value) {
        ArgumentMatchers.reportMatcher(new Equals(value));
        return false;
    }

    public static byte eq(byte value) {
        ArgumentMatchers.reportMatcher(new Equals(value));
        return 0;
    }

    public static char eq(char value) {
        ArgumentMatchers.reportMatcher(new Equals(Character.valueOf(value)));
        return '\u0000';
    }

    public static double eq(double value) {
        ArgumentMatchers.reportMatcher(new Equals(value));
        return 0.0;
    }

    public static float eq(float value) {
        ArgumentMatchers.reportMatcher(new Equals(Float.valueOf(value)));
        return 0.0f;
    }

    public static int eq(int value) {
        ArgumentMatchers.reportMatcher(new Equals(value));
        return 0;
    }

    public static long eq(long value) {
        ArgumentMatchers.reportMatcher(new Equals(value));
        return 0L;
    }

    public static short eq(short value) {
        ArgumentMatchers.reportMatcher(new Equals(value));
        return 0;
    }

    public static <T> T eq(T value) {
        ArgumentMatchers.reportMatcher(new Equals(value));
        if (value == null) {
            return null;
        }
        return (T)Primitives.defaultValue(value.getClass());
    }

    public static <T> T refEq(T value, String ... excludeFields) {
        ArgumentMatchers.reportMatcher(new ReflectionEquals(value, excludeFields));
        return null;
    }

    public static <T> T same(T value) {
        ArgumentMatchers.reportMatcher(new Same(value));
        if (value == null) {
            return null;
        }
        return (T)Primitives.defaultValue(value.getClass());
    }

    public static <T> T isNull() {
        ArgumentMatchers.reportMatcher(Null.NULL);
        return null;
    }

    @Deprecated
    public static <T> T isNull(Class<T> clazz) {
        return ArgumentMatchers.isNull();
    }

    public static <T> T notNull() {
        ArgumentMatchers.reportMatcher(NotNull.NOT_NULL);
        return null;
    }

    @Deprecated
    public static <T> T notNull(Class<T> clazz) {
        return ArgumentMatchers.notNull();
    }

    public static <T> T isNotNull() {
        return ArgumentMatchers.notNull();
    }

    @Deprecated
    public static <T> T isNotNull(Class<T> clazz) {
        return ArgumentMatchers.notNull(clazz);
    }

    public static <T> T nullable(Class<T> clazz) {
        AdditionalMatchers.or(ArgumentMatchers.isNull(), ArgumentMatchers.isA(clazz));
        return Primitives.defaultValue(clazz);
    }

    public static String contains(String substring) {
        ArgumentMatchers.reportMatcher(new Contains(substring));
        return "";
    }

    public static String matches(String regex) {
        ArgumentMatchers.reportMatcher(new Matches(regex));
        return "";
    }

    public static String matches(Pattern pattern) {
        ArgumentMatchers.reportMatcher(new Matches(pattern));
        return "";
    }

    public static String endsWith(String suffix) {
        ArgumentMatchers.reportMatcher(new EndsWith(suffix));
        return "";
    }

    public static String startsWith(String prefix) {
        ArgumentMatchers.reportMatcher(new StartsWith(prefix));
        return "";
    }

    public static <T> T argThat(ArgumentMatcher<T> matcher) {
        ArgumentMatchers.reportMatcher(matcher);
        return null;
    }

    public static char charThat(ArgumentMatcher<Character> matcher) {
        ArgumentMatchers.reportMatcher(matcher);
        return '\u0000';
    }

    public static boolean booleanThat(ArgumentMatcher<Boolean> matcher) {
        ArgumentMatchers.reportMatcher(matcher);
        return false;
    }

    public static byte byteThat(ArgumentMatcher<Byte> matcher) {
        ArgumentMatchers.reportMatcher(matcher);
        return 0;
    }

    public static short shortThat(ArgumentMatcher<Short> matcher) {
        ArgumentMatchers.reportMatcher(matcher);
        return 0;
    }

    public static int intThat(ArgumentMatcher<Integer> matcher) {
        ArgumentMatchers.reportMatcher(matcher);
        return 0;
    }

    public static long longThat(ArgumentMatcher<Long> matcher) {
        ArgumentMatchers.reportMatcher(matcher);
        return 0L;
    }

    public static float floatThat(ArgumentMatcher<Float> matcher) {
        ArgumentMatchers.reportMatcher(matcher);
        return 0.0f;
    }

    public static double doubleThat(ArgumentMatcher<Double> matcher) {
        ArgumentMatchers.reportMatcher(matcher);
        return 0.0;
    }

    private static void reportMatcher(ArgumentMatcher<?> matcher) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportMatcher(matcher);
    }
}

