/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import com.google.common.base.Joiner;
import java.util.List;

public class ArgListExpr
extends Expr {
    private int mId;

    public ArgListExpr(int id, Iterable<Expr> children) {
        super(children);
        this.mId = id;
    }

    @Override
    protected String computeUniqueKey() {
        return "ArgList[" + this.mId + "]" + ArgListExpr.join(this.getChildren());
    }

    @Override
    protected KCode generateCode() {
        throw new IllegalStateException("should never try to convert an argument expressions into code");
    }

    @Override
    public String toString() {
        return "(" + Joiner.on((String)",").join(this.getChildren()) + ")";
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
    }

    public void injectSafeUnboxingForParams(ExprModel exprModel, ModelClass[] params) {
        for (int i = 0; i < params.length; ++i) {
            Expr child = this.getChildren().get(i);
            if (params[i].isNullable() || !child.getResolvedType().isNullable()) continue;
            this.safeUnboxChild(exprModel, child);
        }
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.argListExpr(ArgListExpr.cloneToModel(model, this.getChildren()));
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return modelAnalyzer.findClass(Void.class);
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return super.constructDynamicChildrenDependencies();
    }

    @Override
    public boolean canBeEvaluatedToAVariable() {
        return false;
    }

    @Override
    public String getInvertibleError() {
        return "Merged bindings are not invertible.";
    }
}

