/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="UnusedMethod", altNames={"Unused", "unused", "UnusedParameters"}, summary="Unused.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class UnusedMethod
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final String GWT_JAVASCRIPT_OBJECT = "com.google.gwt.core.client.JavaScriptObject";
    private static final String EXEMPT_PREFIX = "unused";
    private static final String JUNIT_PARAMS_VALUE = "value";
    private static final String JUNIT_PARAMS_ANNOTATION_TYPE = "junitparams.Parameters";
    private static final ImmutableSet<String> EXEMPTING_METHOD_ANNOTATIONS = ImmutableSet.of((Object)"com.fasterxml.jackson.annotation.JsonCreator", (Object)"com.google.inject.Provides", (Object)"com.google.inject.Inject", (Object)"com.google.inject.multibindings.ProvidesIntoMap", (Object)"com.google.inject.multibindings.ProvidesIntoSet", (Object)"javax.annotation.PreDestroy", (Object[])new String[]{"javax.annotation.PostConstruct", "javax.inject.Inject", "javax.persistence.PostLoad", "org.aspectj.lang.annotation.Pointcut", "org.aspectj.lang.annotation.Before", "org.springframework.context.annotation.Bean", "org.testng.annotations.AfterClass", "org.testng.annotations.AfterMethod", "org.testng.annotations.BeforeClass", "org.testng.annotations.BeforeMethod", "org.testng.annotations.DataProvider", "org.junit.AfterClass", "org.junit.BeforeClass"});
    private static final ImmutableSet<String> EXEMPTING_SUPER_TYPES = ImmutableSet.of();
    private static final Supplier<Name> ORG_JUNIT_JUPITER_PARAMS_PROVIDER_METHODSOURCE = VisitorState.memoize((Supplier & Serializable)state -> state.getName("org.junit.jupiter.params.provider.MethodSource"));

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final HashMap unusedMethods = new HashMap();
        if (UnusedMethod.hasNativeMethods(tree)) {
            return Description.NO_MATCH;
        }
        final AtomicBoolean ignoreUnusedMethods = new AtomicBoolean(false);
        class MethodFinder
        extends BugChecker.SuppressibleTreePathScanner<Void, Void> {
            MethodFinder() {
                super((BugChecker)UnusedMethod.this);
            }

            public Void visitClass(ClassTree tree, Void unused) {
                if (this.exemptedBySuperType(ASTHelpers.getType((ClassTree)tree), state)) {
                    return null;
                }
                return (Void)super.visitClass(tree, null);
            }

            private boolean exemptedBySuperType(Type type, VisitorState state2) {
                return EXEMPTING_SUPER_TYPES.stream().anyMatch(t -> ASTHelpers.isSubtype((Type)type, (Type)((Type)Suppliers.typeFromString((String)t).get(state2)), (VisitorState)state2));
            }

            public Void visitMethod(MethodTree tree, Void unused) {
                if (this.hasJUnitParamsParametersForMethodAnnotation(tree.getModifiers().getAnnotations())) {
                    ignoreUnusedMethods.set(true);
                }
                if (this.isMethodSymbolEligibleForChecking(tree)) {
                    unusedMethods.put(ASTHelpers.getSymbol((MethodTree)tree), this.getCurrentPath());
                }
                return (Void)super.visitMethod(tree, (Object)unused);
            }

            private boolean hasJUnitParamsParametersForMethodAnnotation(Collection<? extends AnnotationTree> annotations) {
                for (AnnotationTree annotationTree : annotations) {
                    JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)annotationTree;
                    if (annotation.getAnnotationType().type == null || !annotation.getAnnotationType().type.toString().equals(UnusedMethod.JUNIT_PARAMS_ANNOTATION_TYPE)) continue;
                    if (((List)annotation.getArguments()).isEmpty()) {
                        return true;
                    }
                    for (JCTree.JCExpression arg : annotation.getArguments()) {
                        if (arg.getKind() != Tree.Kind.ASSIGNMENT) {
                            return false;
                        }
                        JCTree.JCExpression var = ((JCTree.JCAssign)arg).getVariable();
                        if (var.getKind() != Tree.Kind.IDENTIFIER || ((IdentifierTree)((Object)var)).getName().contentEquals(UnusedMethod.JUNIT_PARAMS_VALUE)) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean isMethodSymbolEligibleForChecking(MethodTree tree) {
                Type lastParamType;
                if (UnusedMethod.exemptedByName(tree.getName())) {
                    return false;
                }
                if (UnusedMethod.exemptedByAnnotation(tree.getModifiers().getAnnotations())) {
                    return false;
                }
                if (ASTHelpers.shouldKeep((Tree)tree)) {
                    return false;
                }
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)tree);
                if (methodSymbol == null || this.isExemptedConstructor(methodSymbol, state) || Matchers.SERIALIZATION_METHODS.matches((Tree)tree, state)) {
                    return false;
                }
                if (!tree.getParameters().isEmpty() && (lastParamType = ASTHelpers.getType((Tree)((Tree)Iterables.getLast(tree.getParameters())))) != null && lastParamType.toString().equals(UnusedMethod.GWT_JAVASCRIPT_OBJECT)) {
                    return false;
                }
                return tree.getModifiers().getFlags().contains((Object)Modifier.PRIVATE);
            }

            private boolean isExemptedConstructor(Symbol.MethodSymbol methodSymbol, VisitorState state2) {
                if (!methodSymbol.getKind().equals((Object)ElementKind.CONSTRUCTOR)) {
                    return false;
                }
                return methodSymbol.params().isEmpty();
            }
        }
        new MethodFinder().scan(state.getPath(), null);
        class FilterUsedMethods
        extends TreePathScanner<Void, Void> {
            FilterUsedMethods() {
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)memberSelectTree);
                unusedMethods.remove(symbol);
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }

            @Override
            public Void visitMemberReference(MemberReferenceTree tree, Void unused) {
                super.visitMemberReference(tree, null);
                Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MemberReferenceTree)tree);
                unusedMethods.remove(symbol);
                if (symbol != null) {
                    symbol.getParameters().forEach(unusedMethods::remove);
                }
                return null;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitMethodInvocation(tree, null);
            }

            @Override
            public Void visitNewClass(NewClassTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitNewClass(tree, null);
            }

            private void handle(ExpressionTree tree) {
                Symbol methodSymbol = ASTHelpers.getSymbol((Tree)tree);
                if (methodSymbol != null) {
                    unusedMethods.remove(methodSymbol);
                }
            }

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                this.handleMethodSource(tree);
                return (Void)super.visitMethod(tree, null);
            }

            private void handleMethodSource(MethodTree tree) {
                Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
                if (sym == null) {
                    return;
                }
                javax.lang.model.element.Name name = (javax.lang.model.element.Name)ORG_JUNIT_JUPITER_PARAMS_PROVIDER_METHODSOURCE.get(state);
                sym.getRawAttributes().stream().filter(a -> a.type.tsym.getQualifiedName().equals(name)).findAny().flatMap(a -> MoreAnnotations.getAnnotationValue((Attribute.Compound)a, (String)UnusedMethod.JUNIT_PARAMS_VALUE)).map(y -> (ImmutableSet)MoreAnnotations.asStrings((AnnotationValue)y).map(arg_0 -> ((VisitorState)state).getName(arg_0)).map(Object::toString).collect(ImmutableSet.toImmutableSet())).ifPresent(referencedNames -> unusedMethods.entrySet().removeIf(e -> {
                    Symbol unusedSym = (Symbol)e.getKey();
                    String simpleName = unusedSym.getSimpleName().toString();
                    return referencedNames.contains((Object)simpleName) || referencedNames.contains((Object)(unusedSym.owner.getQualifiedName() + "#" + simpleName));
                }));
            }
        }
        new FilterUsedMethods().scan(state.getPath(), null);
        if (ignoreUnusedMethods.get()) {
            return Description.NO_MATCH;
        }
        this.fixNonConstructors((Iterable)unusedMethods.values().stream().filter(t -> !ASTHelpers.getSymbol((Tree)t.getLeaf()).isConstructor()).collect(ImmutableList.toImmutableList()), state);
        ImmutableListMultimap unusedConstructors = (ImmutableListMultimap)unusedMethods.values().stream().filter(t -> ASTHelpers.getSymbol((Tree)t.getLeaf()).isConstructor()).collect(ImmutableListMultimap.toImmutableListMultimap(t -> ASTHelpers.getSymbol((Tree)t.getLeaf()).owner, t -> t));
        this.fixConstructors((ImmutableListMultimap<Symbol, TreePath>)unusedConstructors, state);
        return Description.NO_MATCH;
    }

    private void fixNonConstructors(Iterable<TreePath> unusedPaths, VisitorState state) {
        for (TreePath unusedPath : unusedPaths) {
            Tree unusedTree = unusedPath.getLeaf();
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)((MethodTree)unusedTree));
            String message = String.format("Private method '%s' is never used.", symbol.getSimpleName());
            state.reportMatch(this.buildDescription(unusedTree).addFix((Fix)SuggestedFixes.replaceIncludingComments((TreePath)unusedPath, (String)"", (VisitorState)state)).setMessage(message).build());
        }
    }

    private void fixConstructors(ImmutableListMultimap<Symbol, TreePath> unusedConstructors, VisitorState state) {
        for (Map.Entry entry : Multimaps.asMap(unusedConstructors).entrySet()) {
            boolean fixable;
            Symbol symbol = (Symbol)entry.getKey();
            java.util.List trees = (java.util.List)entry.getValue();
            SuggestedFix.Builder fix = SuggestedFix.builder();
            int constructorCount = Iterables.size((Iterable)symbol.members().getSymbols(Symbol::isConstructor));
            int finalFields = Iterables.size((Iterable)symbol.members().getSymbols(s -> s.getKind().equals((Object)ElementKind.FIELD) && s.getModifiers().contains((Object)Modifier.FINAL)));
            if (constructorCount == trees.size()) {
                fix.postfixWith(((TreePath)Iterables.getLast((Iterable)trees)).getLeaf(), String.format("private %s() {}", symbol.getSimpleName()));
                fixable = finalFields == 0;
            } else {
                fixable = true;
            }
            String message = String.format("Private constructor '%s' is never used.", symbol.getSimpleName());
            trees.forEach(t -> fix.merge(SuggestedFixes.replaceIncludingComments((TreePath)t, (String)"", (VisitorState)state)));
            state.reportMatch(this.buildDescription(((TreePath)trees.get(0)).getLeaf()).addFix((Fix)(fixable ? fix.build() : SuggestedFix.emptyFix())).setMessage(message).build());
        }
    }

    static boolean hasNativeMethods(CompilationUnitTree tree) {
        final AtomicBoolean hasAnyNativeMethods = new AtomicBoolean(false);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (tree.getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
                    hasAnyNativeMethods.set(true);
                }
                return null;
            }
        }.scan(tree, null);
        return hasAnyNativeMethods.get();
    }

    private static boolean exemptedByAnnotation(java.util.List<? extends AnnotationTree> annotations) {
        for (AnnotationTree annotationTree : annotations) {
            Symbol.TypeSymbol tsym;
            Type annotationType = ASTHelpers.getType((Tree)annotationTree);
            if (annotationType == null || !EXEMPTING_METHOD_ANNOTATIONS.contains((Object)(tsym = annotationType.tsym).getQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean exemptedByName(javax.lang.model.element.Name name) {
        return Ascii.toLowerCase((String)name.toString()).startsWith(EXEMPT_PREFIX);
    }
}

