/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReferenceEquality;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;

@BugPattern(name="NumericEquality", summary="Numeric comparison using reference equality instead of value equality", severity=BugPattern.SeverityLevel.ERROR)
public class NumericEquality
extends AbstractReferenceEquality {
    private static final Supplier<Type> JAVA_LANG_NUMBER = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.Number"));

    @Override
    protected boolean matchArgument(ExpressionTree tree, VisitorState state) {
        if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)tree), (Type)((Type)JAVA_LANG_NUMBER.get(state)), (VisitorState)state)) {
            return false;
        }
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        return !(sym instanceof Symbol.VarSymbol) || !NumericEquality.isFinal(sym) || !sym.isStatic();
    }

    public static boolean isFinal(Symbol s) {
        return (s.flags() & 0x10L) == 16L;
    }
}

