/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import javax.lang.model.type.TypeKind;

@BugPattern(name="FloatCast", summary="Use parentheses to make the precedence explicit", severity=BugPattern.SeverityLevel.WARNING)
public class FloatCast
extends BugChecker
implements BugChecker.TypeCastTreeMatcher {
    private static final ImmutableSet<TypeKind> INTEGRAL = Sets.immutableEnumSet((Enum)TypeKind.LONG, (Enum[])new TypeKind[]{TypeKind.INT});
    private static final Matcher<ExpressionTree> IGNORED_METHODS = MethodMatchers.staticMethod().onClass("java.lang.Math").namedAnyOf(new String[]{"floor", "ceil", "signum", "rint"});
    private static final Matcher<ExpressionTree> POW = MethodMatchers.staticMethod().onClass("java.lang.Math").named("pow");

    public Description matchTypeCast(TypeCastTree tree, VisitorState state) {
        BinaryTree enclosingBinop;
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof BinaryTree)) {
            return Description.NO_MATCH;
        }
        BinaryTree binop = (BinaryTree)parent;
        if (!binop.getLeftOperand().equals(tree)) {
            return Description.NO_MATCH;
        }
        if (binop.getKind() != Tree.Kind.MULTIPLY) {
            return Description.NO_MATCH;
        }
        Type castType = ASTHelpers.getType((Tree)tree.getType());
        Type operandType = ASTHelpers.getType((Tree)tree.getExpression());
        if (castType == null || operandType == null) {
            return Description.NO_MATCH;
        }
        Symtab symtab = state.getSymtab();
        if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)parent), (Type)symtab.stringType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        switch (castType.getKind()) {
            case LONG: 
            case INT: 
            case SHORT: 
            case CHAR: 
            case BYTE: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        switch (operandType.getKind()) {
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        if (IGNORED_METHODS.matches((Tree)tree.getExpression(), state)) {
            return Description.NO_MATCH;
        }
        if (POW.matches((Tree)tree.getExpression(), state)) {
            MethodInvocationTree pow = (MethodInvocationTree)tree.getExpression();
            if (pow.getArguments().stream().map(ASTHelpers::getType).filter(x -> x != null).map(state.getTypes()::unboxedTypeOrType).map(Type::getKind).allMatch(arg_0 -> INTEGRAL.contains(arg_0))) {
                return Description.NO_MATCH;
            }
        }
        BinaryTree enclosing = binop;
        for (TreePath path = state.getPath().getParentPath().getParentPath(); path != null && path.getLeaf() instanceof BinaryTree && (enclosingBinop = (BinaryTree)path.getLeaf()).getLeftOperand().equals(enclosing); path = path.getParentPath()) {
            enclosing = enclosingBinop;
        }
        return this.buildDescription(tree).addFix((Fix)SuggestedFix.builder().prefixWith((Tree)tree.getExpression(), "(").postfixWith((Tree)enclosing, ")").build()).addFix((Fix)SuggestedFix.builder().prefixWith((Tree)tree, "(").postfixWith((Tree)tree, ")").build()).build();
    }
}

