/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(name="AssistedInjectAndInjectOnSameConstructor", summary="@AssistedInject and @Inject cannot be used on the same constructor.", severity=BugPattern.SeverityLevel.WARNING)
public class AssistedInjectAndInjectOnSameConstructor
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final Matcher<MethodTree> HAS_ASSISTED_INJECT_MATCHER = Matchers.hasAnnotation((String)"com.google.inject.assistedinject.AssistedInject");
    private static final Matcher<AnnotationTree> injectOrAssistedInjectMatcher = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"javax.inject.Inject"), Matchers.isType((String)"com.google.inject.Inject"), Matchers.isType((String)"com.google.inject.assistedinject.AssistedInject")});

    public Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        Tree treeWithAnnotation;
        if (injectOrAssistedInjectMatcher.matches((Tree)annotationTree, state) && ASTHelpers.getSymbol((Tree)(treeWithAnnotation = state.getPath().getParentPath().getParentPath().getLeaf())).isConstructor() && InjectMatchers.hasInjectAnnotation().matches(treeWithAnnotation, state) && HAS_ASSISTED_INJECT_MATCHER.matches((Tree)((MethodTree)treeWithAnnotation), state)) {
            return this.describeMatch(annotationTree, (Fix)SuggestedFix.delete((Tree)annotationTree));
        }
        return Description.NO_MATCH;
    }
}

