/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="UnusedCollectionModifiedInPlace", summary="Collection is modified in place, but the result is not used", severity=BugPattern.SeverityLevel.ERROR)
public class UnusedCollectionModifiedInPlace
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> COLLECTIONS_DESTRUCTIVE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.util.Collections").named("copy"), Matchers.staticMethod().onClass("java.util.Collections").named("fill"), Matchers.staticMethod().onClass("java.util.Collections").named("reverse"), Matchers.staticMethod().onClass("java.util.Collections").named("rotate"), Matchers.staticMethod().onClass("java.util.Collections").named("shuffle"), Matchers.staticMethod().onClass("java.util.Collections").named("sort"), Matchers.staticMethod().onClass("java.util.Collections").named("swap")});
    private static final Matcher<MethodInvocationTree> FIRST_ARG_CONSTRUCTS_NEW_LIST = Matchers.argument((int)0, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.collect.Lists").named("newArrayList"), Matchers.staticMethod().onClass("com.google.common.collect.Lists").named("newLinkedList"), Matchers.kindIs((Tree.Kind)Tree.Kind.NEW_CLASS)}));
    private static final Matcher<MethodInvocationTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{COLLECTIONS_DESTRUCTIVE, FIRST_ARG_CONSTRUCTS_NEW_LIST});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

