/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Reachability;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;

@BugPattern(name="UnnecessaryDefaultInEnumSwitch", summary="Switch handles all enum values: an explicit default case is unnecessary and defeats error checking for non-exhaustive switches.", severity=BugPattern.SeverityLevel.WARNING)
public class UnnecessaryDefaultInEnumSwitch
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    private static final String DESCRIPTION_MOVED_DEFAULT = "Switch handles all enum values: move code from the default case to execute after the switch statement to enable checking for non-exhaustive switches. That is, prefer: `switch (...) { ... } throw new AssertionError();` to `switch (...) { ... default: throw new AssertionError(); }`";
    private static final String DESCRIPTION_REMOVED_DEFAULT = "Switch handles all enum values: the default case can be omitted to enable enforcement at compile-time that the switch statement is exhaustive.";
    private static final String DESCRIPTION_UNRECOGNIZED = "Switch handles all enum values except for `UNRECOGNIZED`. The default case can be changed to `UNRECOGNIZED` to enable compile-time enforcement that the switch statement is exhaustive";

    public Description matchSwitch(SwitchTree switchTree, VisitorState state) {
        Symbol.TypeSymbol switchType = ((JCTree.JCSwitch)switchTree).getExpression().type.tsym;
        if (switchType.getKind() != ElementKind.ENUM) {
            return Description.NO_MATCH;
        }
        CaseTree caseBeforeDefault = null;
        CaseTree defaultCase = null;
        for (CaseTree caseTree : switchTree.getCases()) {
            if (caseTree.getExpression() == null) {
                defaultCase = caseTree;
                break;
            }
            caseBeforeDefault = caseTree;
        }
        if (caseBeforeDefault == null || defaultCase == null) {
            return Description.NO_MATCH;
        }
        Sets.SetView<String> unhandledCases = UnnecessaryDefaultInEnumSwitch.unhandledCases(switchTree, switchType);
        if (unhandledCases.equals((Object)ImmutableSet.of((Object)"UNRECOGNIZED"))) {
            return this.fixUnrecognized(switchTree, defaultCase, state);
        }
        if (unhandledCases.isEmpty()) {
            return this.fixDefault(switchTree, caseBeforeDefault, defaultCase, state);
        }
        return Description.NO_MATCH;
    }

    private Description fixDefault(SwitchTree switchTree, CaseTree caseBeforeDefault, CaseTree defaultCase, VisitorState state) {
        List<? extends StatementTree> defaultStatements = defaultCase.getStatements();
        if (defaultStatements == null) {
            return this.buildDescription(defaultCase).setMessage(DESCRIPTION_REMOVED_DEFAULT).build();
        }
        if (UnnecessaryDefaultInEnumSwitch.trivialDefault(defaultStatements)) {
            return this.buildDescription(defaultCase).setMessage(DESCRIPTION_REMOVED_DEFAULT).addFix((Fix)SuggestedFix.delete((Tree)defaultCase)).build();
        }
        String defaultContents = UnnecessaryDefaultInEnumSwitch.getDefaultCaseContents(defaultCase, defaultStatements, state);
        if (!Reachability.canCompleteNormally((StatementTree)switchTree)) {
            SuggestedFix fix = SuggestedFix.builder().postfixWith((Tree)switchTree, defaultContents).delete((Tree)defaultCase).build();
            return this.buildDescription(defaultCase).setMessage(DESCRIPTION_MOVED_DEFAULT).addFix((Fix)fix).build();
        }
        if (!SuggestedFixes.compilesWithFix((Fix)SuggestedFix.delete((Tree)defaultCase), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (!Reachability.canCompleteNormally((CaseTree)caseBeforeDefault)) {
            return this.buildDescription(defaultCase).setMessage(DESCRIPTION_REMOVED_DEFAULT).addFix((Fix)SuggestedFix.delete((Tree)defaultCase)).build();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder().delete((Tree)defaultCase);
        fix.postfixWith((Tree)caseBeforeDefault, defaultContents);
        return this.buildDescription(defaultCase).setMessage(DESCRIPTION_REMOVED_DEFAULT).addFix((Fix)fix.build()).build();
    }

    private Description fixUnrecognized(SwitchTree switchTree, CaseTree defaultCase, VisitorState state) {
        List<? extends StatementTree> defaultStatements = defaultCase.getStatements();
        Description.Builder unrecognizedDescription = this.buildDescription(defaultCase).setMessage(DESCRIPTION_UNRECOGNIZED);
        if (defaultStatements == null) {
            return unrecognizedDescription.build();
        }
        if (UnnecessaryDefaultInEnumSwitch.trivialDefault(defaultStatements)) {
            SuggestedFix fix = SuggestedFix.replace((Tree)defaultCase, (String)"case UNRECOGNIZED: \n // continue below");
            return unrecognizedDescription.addFix((Fix)fix).build();
        }
        String defaultContents = UnnecessaryDefaultInEnumSwitch.getDefaultCaseContents(defaultCase, defaultStatements, state);
        if (!Reachability.canCompleteNormally((StatementTree)switchTree)) {
            SuggestedFix fix = SuggestedFix.builder().replace((Tree)defaultCase, "case UNRECOGNIZED: \n break;").postfixWith((Tree)switchTree, defaultContents).build();
            return unrecognizedDescription.addFix((Fix)fix).build();
        }
        SuggestedFix fix = SuggestedFix.replace((Tree)defaultCase, (String)("case UNRECOGNIZED:" + defaultContents));
        if (!SuggestedFixes.compilesWithFix((Fix)fix, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return unrecognizedDescription.addFix((Fix)fix).build();
    }

    private static boolean trivialDefault(List<? extends StatementTree> defaultStatements) {
        if (defaultStatements.isEmpty()) {
            return true;
        }
        return defaultStatements.size() == 1 && ((StatementTree)Iterables.getOnlyElement(defaultStatements)).getKind() == Tree.Kind.BREAK;
    }

    private static Sets.SetView<String> unhandledCases(SwitchTree tree, Symbol.TypeSymbol switchType) {
        ImmutableSet handledCases = (ImmutableSet)tree.getCases().stream().map(CaseTree::getExpression).filter(IdentifierTree.class::isInstance).map(p -> ((IdentifierTree)p).getName().toString()).collect(ImmutableSet.toImmutableSet());
        return Sets.difference((Set)ASTHelpers.enumValues((Symbol.TypeSymbol)switchType), (Set)handledCases);
    }

    private static String getDefaultCaseContents(CaseTree defaultCase, List<? extends StatementTree> defaultStatements, VisitorState state) {
        CharSequence sourceCode = state.getSourceCode();
        if (sourceCode == null) {
            return "";
        }
        String defaultSource = sourceCode.subSequence(ASTHelpers.getStartPosition((Tree)defaultStatements.get(0)), state.getEndPosition((Tree)Iterables.getLast(defaultStatements))).toString();
        String initialComments = UnnecessaryDefaultInEnumSwitch.comments(defaultCase, defaultStatements, sourceCode);
        return initialComments + defaultSource;
    }

    private static String comments(CaseTree defaultCase, List<? extends StatementTree> defaultStatements, CharSequence sourceCode) {
        int statementStart;
        if (defaultStatements.isEmpty()) {
            return "";
        }
        int defaultStart = ASTHelpers.getStartPosition((Tree)defaultCase);
        String defaultAndComments = sourceCode.subSequence(defaultStart, statementStart = ASTHelpers.getStartPosition((Tree)defaultStatements.get(0))).toString();
        Object comments = defaultAndComments.substring(defaultAndComments.indexOf("default:") + "default:".length()).trim();
        if (!((String)comments).isEmpty()) {
            comments = "\n" + (String)comments + "\n";
        }
        return comments;
    }
}

