/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.dagger.DaggerAnnotations;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import java.util.List;
import javax.lang.model.element.Modifier;

@BugPattern(name="InterfaceWithOnlyStatics", summary="This interface only contains static fields and methods; consider making it a final class instead to prevent subclassing.", severity=BugPattern.SeverityLevel.WARNING)
public final class InterfaceWithOnlyStatics
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!tree.getImplementsClause().isEmpty()) {
            return Description.NO_MATCH;
        }
        if (DaggerAnnotations.isAnyModule().matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends Tree> members = tree.getMembers();
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)tree);
        if (symbol == null || !symbol.isInterface() || symbol.isAnnotationType()) {
            return Description.NO_MATCH;
        }
        int staticMembers = 0;
        int nonStaticMembers = 0;
        for (Tree tree2 : members) {
            Symbol symbol2 = ASTHelpers.getSymbol((Tree)tree2);
            if (symbol2 == null) {
                return Description.NO_MATCH;
            }
            if (symbol2.isStatic()) {
                ++staticMembers;
                continue;
            }
            ++nonStaticMembers;
        }
        if (nonStaticMembers > 0 || staticMembers == 0) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder suggestedFix = SuggestedFix.builder();
        for (Tree tree3 : members) {
            if (tree3 instanceof VariableTree) {
                VariableTree variableTree = (VariableTree)tree3;
                SuggestedFixes.addModifiers((Tree)variableTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.STATIC, Modifier.PUBLIC}).ifPresent(arg_0 -> ((SuggestedFix.Builder)suggestedFix).merge(arg_0));
            }
            if (!(tree3 instanceof MethodTree)) continue;
            MethodTree methodTree = (MethodTree)tree3;
            SuggestedFixes.addModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PUBLIC}).ifPresent(arg_0 -> ((SuggestedFix.Builder)suggestedFix).merge(arg_0));
        }
        suggestedFix.merge(InterfaceWithOnlyStatics.fixClass(tree, state)).postfixWith((Tree)Iterables.getLast(members), "\n" + ASTHelpers.createPrivateConstructor((ClassTree)tree));
        return this.describeMatch(tree, (Fix)suggestedFix.build());
    }

    private static SuggestedFix fixClass(ClassTree classTree, VisitorState state) {
        int startPos = ASTHelpers.getStartPosition((Tree)classTree);
        int endPos = ASTHelpers.getStartPosition((Tree)classTree.getMembers().get(0));
        List tokens = state.getOffsetTokens(startPos, endPos);
        String modifiers = ASTHelpers.getSymbol((ClassTree)classTree).owner.enclClass() == null ? "final class" : "static final class";
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (ErrorProneToken token : tokens) {
            if (token.kind() != Tokens.TokenKind.INTERFACE) continue;
            fix.replace(token.pos(), token.endPos(), modifiers);
        }
        return fix.build();
    }
}

