/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

@BugPattern(name="AlreadyChecked", severity=BugPattern.SeverityLevel.WARNING, summary="This condition has already been checked.")
public final class AlreadyChecked
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private final ConstantExpressions constantExpressions;

    public AlreadyChecked(ErrorProneFlags flags) {
        this.constantExpressions = ConstantExpressions.fromFlags(flags);
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        new IfScanner(state).scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private final class IfScanner
    extends BugChecker.SuppressibleTreePathScanner<Void, Void> {
        private final Deque<TreePath> enclosingMethod;
        private final Deque<Set<ConstantExpressions.ConstantExpression>> truthsInMethod;
        private final Deque<Set<ConstantExpressions.ConstantExpression>> falsehoodsInMethod;
        private final Multiset<ConstantExpressions.ConstantExpression> truths;
        private final Multiset<ConstantExpressions.ConstantExpression> falsehoods;
        private final VisitorState state;

        private IfScanner(VisitorState state) {
            super((BugChecker)AlreadyChecked.this);
            this.enclosingMethod = new ArrayDeque<TreePath>();
            this.truthsInMethod = new ArrayDeque<Set<ConstantExpressions.ConstantExpression>>();
            this.falsehoodsInMethod = new ArrayDeque<Set<ConstantExpressions.ConstantExpression>>();
            this.truths = HashMultiset.create();
            this.falsehoods = HashMultiset.create();
            this.state = state;
        }

        public Void visitIf(IfTree tree, Void unused) {
            this.scan((Tree)tree.getCondition(), null);
            ConstantExpressions.Truthiness truthiness = AlreadyChecked.this.constantExpressions.truthiness(tree.getCondition(), false, this.state);
            this.withinScope(truthiness, tree.getThenStatement());
            this.withinScope(AlreadyChecked.this.constantExpressions.truthiness(tree.getCondition(), true, this.state), tree.getElseStatement());
            return null;
        }

        public Void visitReturn(ReturnTree tree, Void unused) {
            super.visitReturn(tree, null);
            this.handleMethodExitingStatement();
            return null;
        }

        public Void visitThrow(ThrowTree tree, Void unused) {
            super.visitThrow(tree, null);
            this.handleMethodExitingStatement();
            return null;
        }

        private void handleMethodExitingStatement() {
            TreePath ifPath;
            Tree previous = null;
            for (ifPath = this.getCurrentPath().getParentPath(); ifPath != null && ifPath.getLeaf() instanceof BlockTree; ifPath = ifPath.getParentPath()) {
                previous = ifPath.getLeaf();
            }
            if (ifPath == null) {
                return;
            }
            TreePath methodPath = this.escapeBlock(ifPath.getParentPath());
            if (methodPath == null || !(ifPath.getLeaf() instanceof IfTree)) {
                return;
            }
            IfTree ifTree = (IfTree)ifPath.getLeaf();
            boolean then = ifTree.getThenStatement().equals(previous);
            if (!this.enclosingMethod.isEmpty() && this.enclosingMethod.getLast().getLeaf().equals(methodPath.getLeaf())) {
                ConstantExpressions.Truthiness truthiness = AlreadyChecked.this.constantExpressions.truthiness(ifTree.getCondition(), then, this.state);
                this.truths.addAll(truthiness.requiredTrue());
                this.falsehoods.addAll(truthiness.requiredFalse());
                this.truthsInMethod.getLast().addAll((Collection<ConstantExpressions.ConstantExpression>)truthiness.requiredTrue());
                this.falsehoodsInMethod.getLast().addAll((Collection<ConstantExpressions.ConstantExpression>)truthiness.requiredFalse());
            }
        }

        private @Nullable TreePath escapeBlock(@Nullable TreePath path) {
            while (path != null && path.getLeaf() instanceof BlockTree) {
                path = path.getParentPath();
            }
            return path;
        }

        public Void visitLambdaExpression(LambdaExpressionTree tree, Void unused) {
            this.withinMethod(() -> super.visitLambdaExpression(tree, null));
            return null;
        }

        public Void visitMethod(MethodTree tree, Void unused) {
            this.withinMethod(() -> super.visitMethod(tree, null));
            return null;
        }

        private void withinMethod(Runnable runnable) {
            this.enclosingMethod.addLast(this.getCurrentPath());
            this.truthsInMethod.addLast(new HashSet());
            this.falsehoodsInMethod.addLast(new HashSet());
            runnable.run();
            this.enclosingMethod.removeLast();
            Multisets.removeOccurrences(this.truths, (Iterable)this.truthsInMethod.removeLast());
            Multisets.removeOccurrences(this.falsehoods, (Iterable)this.falsehoodsInMethod.removeLast());
        }

        private void withinScope(ConstantExpressions.Truthiness truthiness, Tree tree) {
            this.truths.addAll(truthiness.requiredTrue());
            this.falsehoods.addAll(truthiness.requiredFalse());
            this.scan(tree, null);
            Multisets.removeOccurrences(this.truths, truthiness.requiredTrue());
            Multisets.removeOccurrences(this.falsehoods, truthiness.requiredFalse());
        }

        public Void visitConditionalExpression(ConditionalExpressionTree tree, Void unused) {
            this.scan((Tree)tree.getCondition(), null);
            ConstantExpressions.Truthiness truthiness = AlreadyChecked.this.constantExpressions.truthiness(tree.getCondition(), false, this.state);
            this.withinScope(truthiness, tree.getTrueExpression());
            this.withinScope(AlreadyChecked.this.constantExpressions.truthiness(tree.getCondition(), true, this.state), tree.getFalseExpression());
            return null;
        }

        public Void scan(Tree tree, Void unused) {
            if (this.truths.isEmpty() && this.falsehoods.isEmpty()) {
                return (Void)super.scan(tree, null);
            }
            if (this.getCurrentPath().getLeaf() instanceof MethodInvocationTree || this.getCurrentPath().getLeaf() instanceof NewClassTree) {
                return (Void)super.scan(tree, null);
            }
            if (!(tree instanceof ExpressionTree) || !ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree), (Type)this.state.getSymtab().booleanType, (VisitorState)this.state)) {
                return (Void)super.scan(tree, null);
            }
            AlreadyChecked.this.constantExpressions.constantExpression((ExpressionTree)tree, this.state).ifPresent(e -> {
                if (this.truths.contains(e)) {
                    this.state.reportMatch(AlreadyChecked.this.buildDescription(tree).setMessage(String.format("This condition (on %s) is already known to be true; it (or its complement) has already been checked.", e)).build());
                }
                if (this.falsehoods.contains(e)) {
                    this.state.reportMatch(AlreadyChecked.this.buildDescription(tree).setMessage(String.format("This condition (on %s) is known to be false here. It (or its complement) has already been checked.", e)).build());
                }
            });
            return (Void)super.scan(tree, null);
        }
    }
}

