/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.devtools.build.lib.skyframe.serialization.CodecScanner;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodecRegistry;
import java.io.IOException;
import java.util.Comparator;
import java.util.function.Supplier;

public class AutoRegistry {
    private static final Supplier<ObjectCodecRegistry> SUPPLIER = Suppliers.memoize(AutoRegistry::create);
    private static final ImmutableList<String> CLASS_NAME_PREFIX_BLACKLIST = ImmutableList.of((Object)"com.google.devtools.build.lib.google", (Object)"com.google.devtools.build.lib.vfs", (Object)"com.google.devtools.build.lib.actions.ArtifactFactory", (Object)"com.google.devtools.build.lib.packages.PackageFactory$BuiltInRuleFunction", (Object)"com.google.devtools.build.skyframe.SkyFunctionEnvironment");
    private static final ImmutableList<String> EXTERNAL_CLASS_NAMES_TO_REGISTER = ImmutableList.of((Object)"java.io.FileNotFoundException", (Object)"java.io.IOException", (Object)"java.lang.StackTraceElement", (Object)"java.lang.invoke.SerializedLambda", (Object)"com.google.common.base.Predicates$InPredicate", (Object)"com.google.common.collect.ImmutableList$Builder");
    private static final ImmutableList<Object> REFERENCE_CONSTANTS_TO_REGISTER = ImmutableList.of((Object)Predicates.alwaysTrue(), (Object)Predicates.alwaysFalse(), (Object)Predicates.isNull(), (Object)Predicates.notNull(), (Object)ImmutableList.of(), (Object)ImmutableSet.of(), Comparator.naturalOrder(), (Object)Ordering.natural());

    private static boolean packageFilter(String name) {
        return name.startsWith("com.google.devtools.build.lib") || name.startsWith("com.google.devtools.build.sky") || name.startsWith("com.google.devtools.common.options") || name.startsWith("net.starlark.java");
    }

    public static ObjectCodecRegistry get() {
        return SUPPLIER.get();
    }

    private static ObjectCodecRegistry create() {
        try {
            ObjectCodecRegistry.Builder registry = CodecScanner.initializeCodecRegistry(AutoRegistry::packageFilter);
            for (String className : EXTERNAL_CLASS_NAMES_TO_REGISTER) {
                registry.addClassName(className);
            }
            for (Object constant : REFERENCE_CONSTANTS_TO_REGISTER) {
                registry.addReferenceConstant(constant);
            }
            for (String classNamePrefix : CLASS_NAME_PREFIX_BLACKLIST) {
                registry.excludeClassNamePrefix(classNamePrefix);
            }
            return registry.build();
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

