/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.errorprone.refaster.AutoValue_UClassIdent;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.StringName;
import com.google.errorprone.refaster.UIdent;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import javax.annotation.Nullable;

@AutoValue
abstract class UClassIdent
extends UIdent {
    UClassIdent() {
    }

    @VisibleForTesting
    public static UClassIdent create(String qualifiedName) {
        ArrayList<String> topLevelPath = new ArrayList<String>();
        for (String component : Splitter.on((char)'.').split((CharSequence)qualifiedName)) {
            topLevelPath.add(component);
            if (!Character.isUpperCase(component.charAt(0))) continue;
            break;
        }
        return UClassIdent.create(Joiner.on((char)'.').join(topLevelPath), qualifiedName);
    }

    public static UClassIdent create(Symbol.ClassSymbol sym) {
        return UClassIdent.create(ASTHelpers.outermostClass((Symbol)sym).getQualifiedName(), sym.getQualifiedName());
    }

    private static UClassIdent create(CharSequence topLevelClass, CharSequence name) {
        return new AutoValue_UClassIdent(topLevelClass.toString(), StringName.of(name));
    }

    public abstract String getTopLevelClass();

    @Override
    public abstract StringName getName();

    public Symbol.ClassSymbol resolve(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.resolveClass(this.getName());
    }

    @Override
    public JCTree.JCExpression inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.importPolicy().classReference(inliner, this.getTopLevelClass(), this.getName());
    }

    @Override
    @Nullable
    protected Choice<Unifier> defaultAction(Tree tree, @Nullable Unifier unifier) {
        return this.unify(ASTHelpers.getSymbol((Tree)tree), unifier);
    }

    @Override
    @Nullable
    public Choice<Unifier> unify(@Nullable Symbol symbol, Unifier unifier) {
        return symbol != null ? this.getName().unify(symbol.getQualifiedName(), unifier) : Choice.none();
    }
}

