/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;

@BugPattern(name="EmptyTopLevelDeclaration", summary="Empty top-level type declaration", severity=BugPattern.SeverityLevel.WARNING)
public class EmptyTopLevelDeclaration
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ArrayList<Tree> toDelete = new ArrayList<Tree>();
        for (Tree tree2 : tree.getTypeDecls()) {
            if (tree2.getKind() != Tree.Kind.EMPTY_STATEMENT) continue;
            toDelete.add(tree2);
        }
        if (toDelete.isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        for (Tree member : toDelete) {
            fixBuilder.delete(member);
        }
        return this.describeMatch((Tree)toDelete.get(0), (Fix)fixBuilder.build());
    }
}

