/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation.inference;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableGraph;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.inference.InferenceVariable;
import com.google.errorprone.dataflow.nullnesspropagation.inference.ProperInferenceVar;
import com.google.errorprone.dataflow.nullnesspropagation.inference.TypeArgInferenceVar;
import com.google.errorprone.dataflow.nullnesspropagation.inference.TypeVariableInferenceVar;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class InferredNullability {
    private final ImmutableGraph<InferenceVariable> constraintGraph;
    private final Map<InferenceVariable, Optional<Nullness>> inferredMemoTable = new HashMap<InferenceVariable, Optional<Nullness>>();

    InferredNullability(Graph<InferenceVariable> constraints) {
        this.constraintGraph = ImmutableGraph.copyOf(constraints);
    }

    public ImmutableMap<Symbol.TypeVariableSymbol, Nullness> getNullnessGenerics(MethodInvocationTree callsite) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Symbol.TypeVariableSymbol tvs : TreeInfo.symbol((JCTree)((Object)callsite.getMethodSelect())).getTypeParameters()) {
            TypeVariableInferenceVar iv = TypeVariableInferenceVar.create(tvs, callsite);
            if (!this.constraintGraph.nodes().contains(iv)) continue;
            this.getNullness(iv).ifPresent(nullness -> result.put((Object)tvs, (Object)nullness));
        }
        return result.build();
    }

    public Optional<Nullness> getExprNullness(ExpressionTree exprTree) {
        TypeArgInferenceVar iv = TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.of(), exprTree);
        return this.constraintGraph.nodes().contains(iv) ? this.getNullness(iv) : Optional.empty();
    }

    private Optional<Nullness> getNullness(InferenceVariable iv) {
        if (iv instanceof ProperInferenceVar) {
            return Optional.of(((ProperInferenceVar)iv).nullness());
        }
        Optional<Nullness> result = this.inferredMemoTable.get(iv);
        if (result != null) {
            return result;
        }
        this.inferredMemoTable.put(iv, Optional.empty());
        result = this.constraintGraph.predecessors((Object)iv).stream().map(this::getNullness).filter(Optional::isPresent).map(Optional::get).reduce(Nullness::leastUpperBound);
        if (!result.isPresent()) {
            result = this.constraintGraph.successors((Object)iv).stream().map(this::getNullness).filter(Optional::isPresent).map(Optional::get).reduce(Nullness::greatestLowerBound);
        }
        Preconditions.checkState((!this.inferredMemoTable.put(iv, result).isPresent() ? 1 : 0) != 0);
        return result;
    }
}

