/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class LibraryClass
implements Clazz {
    public int u2accessFlags;
    public String thisClassName;
    public String superClassName;
    public String[] interfaceNames;
    public LibraryField[] fields;
    public LibraryMethod[] methods;
    public Clazz superClass;
    public Clazz[] interfaceClasses;
    public Clazz[] subClasses;
    public Object visitorInfo;

    boolean isVisible() {
        return (this.u2accessFlags & 1) != 0;
    }

    @Override
    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    @Override
    public String getName() {
        return this.thisClassName;
    }

    @Override
    public String getSuperName() {
        return this.superClassName;
    }

    @Override
    public int getInterfaceCount() {
        return this.interfaceClasses.length;
    }

    @Override
    public String getInterfaceName(int n) {
        return this.interfaceNames[n];
    }

    @Override
    public int getTag(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getString(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getStringString(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getClassName(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getName(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getType(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getRefClassName(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getRefName(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getRefType(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public void addSubClass(Clazz clazz) {
        if (this.subClasses == null) {
            this.subClasses = new Clazz[1];
        } else {
            Clazz[] clazzArray = new Clazz[this.subClasses.length + 1];
            System.arraycopy(this.subClasses, 0, clazzArray, 0, this.subClasses.length);
            this.subClasses = clazzArray;
        }
        this.subClasses[this.subClasses.length - 1] = clazz;
    }

    @Override
    public Clazz getSuperClass() {
        return this.superClass;
    }

    @Override
    public Clazz getInterface(int n) {
        return this.interfaceClasses[n];
    }

    @Override
    public boolean extends_(Clazz clazz) {
        if (this.equals(clazz)) {
            return true;
        }
        return this.superClass != null && this.superClass.extends_(clazz);
    }

    @Override
    public boolean extends_(String string) {
        if (this.getName().equals(string)) {
            return true;
        }
        return this.superClass != null && this.superClass.extends_(string);
    }

    @Override
    public boolean extendsOrImplements(Clazz clazz) {
        if (this.equals(clazz)) {
            return true;
        }
        if (this.superClass != null && this.superClass.extendsOrImplements(clazz)) {
            return true;
        }
        if (this.interfaceClasses != null) {
            for (int i = 0; i < this.interfaceClasses.length; ++i) {
                Clazz clazz2 = this.interfaceClasses[i];
                if (clazz2 == null || !clazz2.extendsOrImplements(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean extendsOrImplements(String string) {
        if (this.getName().equals(string)) {
            return true;
        }
        if (this.superClass != null && this.superClass.extendsOrImplements(string)) {
            return true;
        }
        if (this.interfaceClasses != null) {
            for (int i = 0; i < this.interfaceClasses.length; ++i) {
                Clazz clazz = this.interfaceClasses[i];
                if (clazz == null || !clazz.extendsOrImplements(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Field findField(String string, String string2) {
        for (int i = 0; i < this.fields.length; ++i) {
            LibraryField libraryField = this.fields[i];
            if (libraryField == null || string != null && !libraryField.getName(this).equals(string) || string2 != null && !libraryField.getDescriptor(this).equals(string2)) continue;
            return libraryField;
        }
        return null;
    }

    @Override
    public Method findMethod(String string, String string2) {
        for (int i = 0; i < this.methods.length; ++i) {
            LibraryMethod libraryMethod = this.methods[i];
            if (libraryMethod == null || string != null && !libraryMethod.getName(this).equals(string) || string2 != null && !libraryMethod.getDescriptor(this).equals(string2)) continue;
            return libraryMethod;
        }
        return null;
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitLibraryClass(this);
    }

    @Override
    public void hierarchyAccept(boolean bl, boolean bl2, boolean bl3, boolean bl4, ClassVisitor classVisitor) {
        int n;
        if (bl) {
            this.accept(classVisitor);
        }
        if (bl2 && this.superClass != null) {
            this.superClass.hierarchyAccept(true, true, bl3, false, classVisitor);
        }
        if (bl3) {
            if (!bl2 && this.superClass != null) {
                this.superClass.hierarchyAccept(false, false, true, false, classVisitor);
            }
            if (this.interfaceClasses != null) {
                for (n = 0; n < this.interfaceClasses.length; ++n) {
                    Clazz clazz = this.interfaceClasses[n];
                    if (clazz == null) continue;
                    clazz.hierarchyAccept(true, false, true, false, classVisitor);
                }
            }
        }
        if (bl4 && this.subClasses != null) {
            for (n = 0; n < this.subClasses.length; ++n) {
                this.subClasses[n].hierarchyAccept(true, false, false, true, classVisitor);
            }
        }
    }

    public void superClassAccept(ClassVisitor classVisitor) {
        if (this.superClass != null) {
            this.superClass.accept(classVisitor);
        }
    }

    public void interfacesAccept(ClassVisitor classVisitor) {
        if (this.interfaceClasses != null) {
            for (int i = 0; i < this.interfaceClasses.length; ++i) {
                Clazz clazz = this.interfaceClasses[i];
                if (clazz == null) continue;
                clazz.accept(classVisitor);
            }
        }
    }

    @Override
    public void subclassesAccept(ClassVisitor classVisitor) {
        if (this.subClasses != null) {
            for (int i = 0; i < this.subClasses.length; ++i) {
                this.subClasses[i].accept(classVisitor);
            }
        }
    }

    @Override
    public void constantPoolEntriesAccept(ConstantVisitor constantVisitor) {
    }

    @Override
    public void constantPoolEntryAccept(int n, ConstantVisitor constantVisitor) {
    }

    @Override
    public void thisClassConstantAccept(ConstantVisitor constantVisitor) {
    }

    @Override
    public void superClassConstantAccept(ConstantVisitor constantVisitor) {
    }

    @Override
    public void interfaceConstantsAccept(ConstantVisitor constantVisitor) {
    }

    @Override
    public void fieldsAccept(MemberVisitor memberVisitor) {
        for (int i = 0; i < this.fields.length; ++i) {
            LibraryField libraryField = this.fields[i];
            if (libraryField == null) continue;
            libraryField.accept((Clazz)this, memberVisitor);
        }
    }

    @Override
    public void fieldAccept(String string, String string2, MemberVisitor memberVisitor) {
        Field field = this.findField(string, string2);
        if (field != null) {
            field.accept(this, memberVisitor);
        }
    }

    @Override
    public void methodsAccept(MemberVisitor memberVisitor) {
        for (int i = 0; i < this.methods.length; ++i) {
            LibraryMethod libraryMethod = this.methods[i];
            if (libraryMethod == null) continue;
            libraryMethod.accept((Clazz)this, memberVisitor);
        }
    }

    @Override
    public void methodAccept(String string, String string2, MemberVisitor memberVisitor) {
        Method method = this.findMethod(string, string2);
        if (method != null) {
            method.accept(this, memberVisitor);
        }
    }

    @Override
    public boolean mayHaveImplementations(Method method) {
        return (this.u2accessFlags & 0x10) == 0 && (method == null || (method.getAccessFlags() & 0x1A) == 0 && !method.getName(this).equals("<init>"));
    }

    @Override
    public void attributesAccept(AttributeVisitor attributeVisitor) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store attributes");
    }

    @Override
    public void attributeAccept(String string, AttributeVisitor attributeVisitor) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store attributes");
    }

    @Override
    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    @Override
    public void setVisitorInfo(Object object) {
        this.visitorInfo = object;
    }

    public String toString() {
        return "LibraryClass(" + this.getName() + ")";
    }
}

