/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Position;
import java.util.Optional;

@BugPattern(name="SuppressWarningsWithoutExplanation", summary="Use of @SuppressWarnings should be accompanied by a comment describing why the warning is safe to ignore.", severity=BugPattern.SeverityLevel.WARNING, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s8.4.2-how-to-handle-a-warning")
public final class SuppressWarningsWithoutExplanation
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<AnnotationTree> SUPPRESS_WARNINGS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isSameType(SuppressWarnings.class), Matchers.hasArgumentWithValue((String)"value", (Matcher)Matchers.stringLiteral((String)"deprecation"))});
    private final boolean emitDummyFixes;

    public SuppressWarningsWithoutExplanation() {
        this(false);
    }

    public SuppressWarningsWithoutExplanation(boolean emitDummyFixes) {
        this.emitDummyFixes = emitDummyFixes;
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        if (!ASTHelpers.getGeneratedBy((VisitorState)state).isEmpty()) {
            return Description.NO_MATCH;
        }
        final ImmutableRangeSet<Long> linesWithComments = SuppressWarningsWithoutExplanation.linesWithComments(state);
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(){

            public Void visitAnnotation(AnnotationTree annotationTree, Void unused) {
                Tree parent;
                if (!SUPPRESS_WARNINGS.matches((Tree)annotationTree, state)) {
                    return (Void)super.visitAnnotation(annotationTree, null);
                }
                LineMap lineMap = state.getPath().getCompilationUnit().getLineMap();
                Range linesCovered = Range.closed((Comparable)Long.valueOf(lineMap.getLineNumber(((JCTree)(parent = this.getCurrentPath().getParentPath().getLeaf())).getStartPosition()) - 1L), (Comparable)Long.valueOf(lineMap.getLineNumber(state.getEndPosition(parent)) + 1L));
                if (!linesWithComments.intersects(linesCovered)) {
                    state.reportMatch(SuppressWarningsWithoutExplanation.this.describeMatch(annotationTree, SuppressWarningsWithoutExplanation.this.emitDummyFixes ? Optional.of(SuggestedFix.postfixWith((Tree)annotationTree, (String)" // Safe because...")) : Optional.empty()));
                }
                return (Void)super.visitAnnotation(annotationTree, null);
            }
        }.scan((Tree)tree, null);
        return Description.NO_MATCH;
    }

    private static ImmutableRangeSet<Long> linesWithComments(VisitorState state) {
        TreeRangeSet lines = TreeRangeSet.create();
        ErrorProneTokens tokens = new ErrorProneTokens(state.getSourceCode().toString(), state.context);
        Position.LineMap lineMap = tokens.getLineMap();
        for (ErrorProneToken token : tokens.getTokens()) {
            for (Tokens.Comment comment : token.comments()) {
                lines.add(Range.closed((Comparable)Long.valueOf(lineMap.getLineNumber((long)comment.getSourcePos(0))), (Comparable)Long.valueOf(lineMap.getLineNumber((long)comment.getSourcePos(comment.getText().length() - 1)))));
            }
        }
        return ImmutableRangeSet.copyOf((RangeSet)lines);
    }
}

