/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_AbstractMockChecker_Reason;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class AbstractMockChecker<T extends Annotation>
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.VariableTreeMatcher {
    public static final TypeExtractor<MethodInvocationTree> MOCKING_METHOD = AbstractMockChecker.extractFirstArg((Matcher<MethodInvocationTree>)Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.staticMethod().onClass("org.mockito.Mockito").namedAnyOf(new String[]{"mock", "spy"}))).or(AbstractMockChecker.extractClassArg((Matcher<MethodInvocationTree>)Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.staticMethod().onClass("org.easymock.EasyMock").withNameMatching(Pattern.compile("^create.*Mock(Builder)?$")))));
    private final TypeExtractor<VariableTree> varExtractor;
    private final TypeExtractor<MethodInvocationTree> methodExtractor;
    private final Class<T> annotationClass;
    private final String annotationName;
    private final Function<T, String> getValueFunction;
    private final Supplier<MockForbidder> forbidder = Suppliers.memoize(this::forbidder);

    public AbstractMockChecker(TypeExtractor<VariableTree> varExtractor, TypeExtractor<MethodInvocationTree> methodExtractor, Class<T> annotationClass, Function<T, String> getValueFunction) {
        this.varExtractor = varExtractor;
        this.methodExtractor = methodExtractor;
        this.annotationClass = annotationClass;
        this.getValueFunction = getValueFunction;
        this.annotationName = annotationClass.getSimpleName();
    }

    protected MockForbidder forbidder() {
        return (type, state) -> Optional.empty();
    }

    public static <T extends Tree> TypeExtractor<T> extractType(Matcher<T> m) {
        return (tree, state) -> {
            if (m.matches(tree, state)) {
                return Optional.ofNullable(ASTHelpers.getType((Tree)tree));
            }
            return Optional.empty();
        };
    }

    public static TypeExtractor<MethodInvocationTree> extractFirstArg(Matcher<MethodInvocationTree> m) {
        return (tree, state) -> {
            if (m.matches(tree, state)) {
                return Optional.ofNullable(ASTHelpers.getType((Tree)tree.getArguments().get(0)));
            }
            return Optional.empty();
        };
    }

    public static TypeExtractor<MethodInvocationTree> extractClassArg(Matcher<MethodInvocationTree> m) {
        return (tree, state) -> {
            if (m.matches(tree, state)) {
                for (ExpressionTree expressionTree : tree.getArguments()) {
                    Type argumentType = ASTHelpers.getType((Tree)expressionTree);
                    if (!ASTHelpers.isSameType((Type)argumentType, (Type)state.getSymtab().classType, (VisitorState)state)) continue;
                    return Optional.of(argumentType);
                }
                throw new IllegalStateException();
            }
            return Optional.empty();
        };
    }

    public static TypeExtractor<VariableTree> fieldAnnotatedWithOneOf(Stream<String> annotationClasses) {
        return AbstractMockChecker.extractType(Matchers.allOf((Matcher[])new Matcher[]{Matchers.isField(), Matchers.anyOf((Iterable)annotationClasses.map(Matchers::hasAnnotation).collect(Collectors.toList()))}));
    }

    public final Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.methodExtractor.extract(tree, state).flatMap(type -> AbstractMockChecker.argFromClass(type, state)).map(type -> this.checkMockedType((Type)type, tree, state)).orElse(Description.NO_MATCH);
    }

    public final Description matchVariable(VariableTree tree, VisitorState state) {
        return this.varExtractor.extract(tree, state).map(type -> this.checkMockedType((Type)type, tree, state)).orElse(Description.NO_MATCH);
    }

    private Description checkMockedType(Type mockedClass, Tree tree, VisitorState state) {
        if (ASTHelpers.isSameType((Type)Type.noType, (Type)mockedClass, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        for (Type currentType : Lists.reverse(state.getTypes().closure(mockedClass))) {
            Symbol.TypeSymbol currentSymbol = currentType.asElement();
            T doNotMock = currentSymbol.getAnnotation(this.annotationClass);
            if (doNotMock != null) {
                return this.buildDescription(tree).setMessage(this.buildMessage(mockedClass, currentSymbol, doNotMock)).build();
            }
            for (Attribute.Compound compound : currentSymbol.getAnnotationMirrors()) {
                Symbol.TypeSymbol metaAnnotationType = (Symbol.TypeSymbol)compound.getAnnotationType().asElement();
                try {
                    metaAnnotationType.complete();
                }
                catch (Symbol.CompletionFailure e) {
                    continue;
                }
                doNotMock = metaAnnotationType.getAnnotation(this.annotationClass);
                if (doNotMock == null) continue;
                return this.buildDescription(tree).setMessage(this.buildMessage(mockedClass, currentSymbol, metaAnnotationType, doNotMock)).build();
            }
        }
        return this.forbidder.get().forbidReason(mockedClass, state).map(reason -> this.buildDescription(tree).setMessage(AbstractMockChecker.buildMessage(mockedClass, reason.unmockableClass().tsym, reason.reason())).build()).orElse(Description.NO_MATCH);
    }

    private static Optional<Type> argFromClass(Type type, VisitorState state) {
        if (ASTHelpers.isSameType((Type)type, (Type)state.getSymtab().classType, (VisitorState)state)) {
            if (type.getTypeArguments().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(state.getTypes().erasure((Type)Iterables.getOnlyElement(type.getTypeArguments())));
        }
        return Optional.of(type);
    }

    private String buildMessage(Type mockedClass, Symbol.TypeSymbol forbiddenType, T doNotMock) {
        return this.buildMessage(mockedClass, forbiddenType, null, doNotMock);
    }

    private String buildMessage(Type mockedClass, Symbol.TypeSymbol forbiddenType, @Nullable Symbol.TypeSymbol metaAnnotationType, T doNotMock) {
        return String.format("%s; %s is annotated as @%s%s: %s.", AbstractMockChecker.buildMessage(mockedClass, forbiddenType), forbiddenType, metaAnnotationType == null ? this.annotationName : metaAnnotationType, metaAnnotationType == null ? "" : String.format(" (which is annotated as @%s)", this.annotationName), Optional.ofNullable(Strings.emptyToNull((String)this.getValueFunction.apply(doNotMock))).orElseGet(() -> String.format("It is annotated as %s.", this.annotationName)));
    }

    private static String buildMessage(Type mockedClass, Symbol.TypeSymbol forbiddenType) {
        return String.format("Do not mock '%s'%s", mockedClass, mockedClass.asElement().equals(forbiddenType) ? "" : " (which is-a '" + forbiddenType + "')");
    }

    private static String buildMessage(Type mockedClass, Symbol.TypeSymbol forbiddenType, String reason) {
        return String.format("%s: %s.", AbstractMockChecker.buildMessage(mockedClass, forbiddenType), reason);
    }

    public static interface TypeExtractor<T extends Tree> {
        public Optional<Type> extract(T var1, VisitorState var2);

        default public TypeExtractor<T> or(TypeExtractor<T> other) {
            return (tree, state) -> this.extract(tree, state).map(Optional::of).orElseGet(() -> other.extract(tree, state));
        }
    }

    @AutoValue
    public static abstract class Reason {
        public static Reason of(Type t, String reason) {
            return new AutoValue_AbstractMockChecker_Reason(t, reason);
        }

        public abstract Type unmockableClass();

        public abstract String reason();
    }

    public static interface MockForbidder {
        public Optional<Reason> forbidReason(Type var1, VisitorState var2);
    }
}

