/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.diag;

import com.google.common.collect.ImmutableList;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineDiagnostic;
import com.google.turbine.diag.TurbineError;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.tools.Diagnostic;

public class TurbineLog {
    private final Set<TurbineDiagnostic> diagnostics = new LinkedHashSet<TurbineDiagnostic>();

    public TurbineLogWithSource withSource(SourceFile source) {
        return new TurbineLogWithSource(source);
    }

    public ImmutableList<TurbineDiagnostic> diagnostics() {
        return ImmutableList.copyOf(this.diagnostics);
    }

    public void maybeThrow() {
        if (this.anyErrors()) {
            throw new TurbineError(this.diagnostics());
        }
    }

    public boolean anyErrors() {
        for (TurbineDiagnostic error : this.diagnostics) {
            if (!error.severity().equals((Object)Diagnostic.Kind.ERROR)) continue;
            return true;
        }
        return false;
    }

    public boolean errorRaised() {
        for (TurbineDiagnostic error : this.diagnostics) {
            if (!error.kind().equals((Object)TurbineError.ErrorKind.PROC) || !error.severity().equals((Object)Diagnostic.Kind.ERROR)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.diagnostics.removeIf(TurbineDiagnostic::isError);
    }

    public void diagnostic(Diagnostic.Kind severity, String message) {
        this.diagnostics.add(TurbineDiagnostic.format(severity, TurbineError.ErrorKind.PROC, message));
    }

    public class TurbineLogWithSource {
        private final SourceFile source;

        private TurbineLogWithSource(SourceFile source) {
            this.source = source;
        }

        public void diagnostic(Diagnostic.Kind severity, int position, TurbineError.ErrorKind kind, Object ... args) {
            TurbineLog.this.diagnostics.add(TurbineDiagnostic.format(severity, this.source, position, kind, args));
        }

        public void error(int position, TurbineError.ErrorKind kind, Object ... args) {
            this.diagnostic(Diagnostic.Kind.ERROR, position, kind, args);
        }
    }
}

