/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Pool {
    public static final int MAX_ENTRIES = 65535;
    public static final int MAX_STRING_LENGTH = 65535;
    int pp;
    Object[] pool;
    Map<Object, Integer> indices;
    Types types;

    public Pool(int pp, Object[] pool, Types types) {
        this.pp = pp;
        this.pool = pool;
        this.types = types;
        this.indices = new HashMap<Object, Integer>(pool.length);
        for (int i = 1; i < pp; ++i) {
            if (pool[i] == null) continue;
            this.indices.put(pool[i], i);
        }
    }

    public Pool(Types types) {
        this(1, new Object[64], types);
    }

    public int numEntries() {
        return this.pp;
    }

    public void reset() {
        this.pp = 1;
        this.indices.clear();
    }

    public int put(Object value) {
        Assert.check(!((value = this.makePoolValue(value)) instanceof Type.TypeVar));
        Assert.check(!(value instanceof Types.UniqueType) || !(((Types.UniqueType)value).type instanceof Type.TypeVar));
        Integer index = this.indices.get(value);
        if (index == null) {
            index = this.pp;
            this.indices.put(value, index);
            this.pool = ArrayUtils.ensureCapacity(this.pool, this.pp);
            this.pool[this.pp++] = value;
            if (value instanceof Long || value instanceof Double) {
                this.pool = ArrayUtils.ensureCapacity(this.pool, this.pp);
                this.pool[this.pp++] = null;
            }
        }
        return index;
    }

    Object makePoolValue(Object o) {
        if (o instanceof Symbol.DynamicMethodSymbol) {
            return new DynamicMethod((Symbol.DynamicMethodSymbol)o, this.types);
        }
        if (o instanceof Symbol.MethodSymbol) {
            return new Method((Symbol.MethodSymbol)o, this.types);
        }
        if (o instanceof Symbol.VarSymbol) {
            return new Variable((Symbol.VarSymbol)o, this.types);
        }
        if (o instanceof Type) {
            Type t = (Type)o;
            if (t.hasTag(TypeTag.CLASS)) {
                return t.tsym;
            }
            return new Types.UniqueType(t, this.types);
        }
        return o;
    }

    public int get(Object o) {
        Integer n = this.indices.get(o);
        return n == null ? -1 : n;
    }

    public static class MethodHandle {
        int refKind;
        Symbol refSym;
        Types.UniqueType uniqueType;
        Filter<Name> nonInitFilter = n -> n != n.table.names.init && n != n.table.names.clinit;
        Filter<Name> initFilter = n -> n == n.table.names.init;

        public MethodHandle(int refKind, Symbol refSym, Types types) {
            this.refKind = refKind;
            this.refSym = refSym;
            this.uniqueType = new Types.UniqueType(this.refSym.type, types);
            this.checkConsistent();
        }

        public boolean equals(Object other) {
            if (!(other instanceof MethodHandle)) {
                return false;
            }
            MethodHandle mr = (MethodHandle)other;
            if (mr.refKind != this.refKind) {
                return false;
            }
            Symbol o = mr.refSym;
            return o.name == this.refSym.name && o.owner == this.refSym.owner && ((MethodHandle)other).uniqueType.equals(this.uniqueType);
        }

        public int hashCode() {
            return this.refKind * 65 + this.refSym.name.hashCode() * 33 + this.refSym.owner.hashCode() * 9 + this.uniqueType.hashCode();
        }

        private void checkConsistent() {
            boolean staticOk = false;
            Kinds.Kind expectedKind = null;
            Filter<Name> nameFilter = this.nonInitFilter;
            boolean interfaceOwner = false;
            switch (this.refKind) {
                case 2: 
                case 4: {
                    staticOk = true;
                }
                case 1: 
                case 3: {
                    expectedKind = Kinds.Kind.VAR;
                    break;
                }
                case 8: {
                    nameFilter = this.initFilter;
                    expectedKind = Kinds.Kind.MTH;
                    break;
                }
                case 9: {
                    interfaceOwner = true;
                    expectedKind = Kinds.Kind.MTH;
                    break;
                }
                case 6: {
                    interfaceOwner = true;
                    staticOk = true;
                }
                case 5: {
                    expectedKind = Kinds.Kind.MTH;
                    break;
                }
                case 7: {
                    interfaceOwner = true;
                    expectedKind = Kinds.Kind.MTH;
                }
            }
            Assert.check(!this.refSym.isStatic() || staticOk);
            Assert.check(this.refSym.kind == expectedKind);
            Assert.check(nameFilter.accepts(this.refSym.name));
            Assert.check(!this.refSym.owner.isInterface() || interfaceOwner);
        }
    }

    static class Variable
    extends Symbol.DelegatedSymbol<Symbol.VarSymbol> {
        Types.UniqueType uniqueType;

        Variable(Symbol.VarSymbol v, Types types) {
            super(v);
            this.uniqueType = new Types.UniqueType(v.type, types);
        }

        @Override
        public boolean equals(Object any) {
            if (!(any instanceof Variable)) {
                return false;
            }
            Symbol.VarSymbol o = (Symbol.VarSymbol)((Variable)any).other;
            Symbol.VarSymbol v = (Symbol.VarSymbol)this.other;
            return o.name == v.name && o.owner == v.owner && ((Variable)any).uniqueType.equals(this.uniqueType);
        }

        @Override
        public int hashCode() {
            Symbol.VarSymbol v = (Symbol.VarSymbol)this.other;
            return v.name.hashCode() * 33 + v.owner.hashCode() * 9 + this.uniqueType.hashCode();
        }
    }

    public static class DynamicMethod
    extends Method {
        public Object[] uniqueStaticArgs;

        public DynamicMethod(Symbol.DynamicMethodSymbol m, Types types) {
            super(m, types);
            this.uniqueStaticArgs = this.getUniqueTypeArray(m.staticArgs, types);
        }

        @Override
        public boolean equals(Object any) {
            return this.equalsImpl(any, true);
        }

        protected boolean equalsImpl(Object any, boolean includeDynamicArgs) {
            if (includeDynamicArgs && !super.equals(any)) {
                return false;
            }
            if (!(any instanceof DynamicMethod)) {
                return false;
            }
            Symbol.DynamicMethodSymbol dm1 = (Symbol.DynamicMethodSymbol)this.other;
            Symbol.DynamicMethodSymbol dm2 = (Symbol.DynamicMethodSymbol)((DynamicMethod)any).other;
            return dm1.bsm == dm2.bsm && dm1.bsmKind == dm2.bsmKind && Arrays.equals(this.uniqueStaticArgs, ((DynamicMethod)any).uniqueStaticArgs);
        }

        @Override
        public int hashCode() {
            return this.hashCodeImpl(true);
        }

        protected int hashCodeImpl(boolean includeDynamicArgs) {
            int hash = includeDynamicArgs ? super.hashCode() : 0;
            Symbol.DynamicMethodSymbol dm = (Symbol.DynamicMethodSymbol)this.other;
            hash += dm.bsmKind * 7 + dm.bsm.hashCode() * 11;
            for (int i = 0; i < dm.staticArgs.length; ++i) {
                hash += this.uniqueStaticArgs[i].hashCode() * 23;
            }
            return hash;
        }

        private Object[] getUniqueTypeArray(Object[] objects, Types types) {
            Object[] result = new Object[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                result[i] = objects[i] instanceof Type ? new Types.UniqueType((Type)objects[i], types) : objects[i];
            }
            return result;
        }

        static class BootstrapMethodsValue {
            final MethodHandle mh;
            final int index;

            public BootstrapMethodsValue(MethodHandle mh, int index) {
                this.mh = mh;
                this.index = index;
            }
        }

        static class BootstrapMethodsKey
        extends DynamicMethod {
            BootstrapMethodsKey(Symbol.DynamicMethodSymbol m, Types types) {
                super(m, types);
            }

            @Override
            public boolean equals(Object any) {
                return this.equalsImpl(any, false);
            }

            @Override
            public int hashCode() {
                return this.hashCodeImpl(false);
            }

            Object[] getUniqueArgs() {
                return this.uniqueStaticArgs;
            }
        }
    }

    static class Method
    extends Symbol.DelegatedSymbol<Symbol.MethodSymbol> {
        Types.UniqueType uniqueType;

        Method(Symbol.MethodSymbol m, Types types) {
            super(m);
            this.uniqueType = new Types.UniqueType(m.type, types);
        }

        @Override
        public boolean equals(Object any) {
            if (!(any instanceof Method)) {
                return false;
            }
            Symbol.MethodSymbol o = (Symbol.MethodSymbol)((Method)any).other;
            Symbol.MethodSymbol m = (Symbol.MethodSymbol)this.other;
            return o.name == m.name && o.owner == m.owner && ((Method)any).uniqueType.equals(this.uniqueType);
        }

        @Override
        public int hashCode() {
            Symbol.MethodSymbol m = (Symbol.MethodSymbol)this.other;
            return m.name.hashCode() * 33 + m.owner.hashCode() * 9 + this.uniqueType.hashCode();
        }
    }
}

