/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ScheduledRunnable
extends AtomicReferenceArray<Object>
implements Runnable,
Callable<Object>,
Disposable {
    private static final long serialVersionUID = -6120223772001106981L;
    final Runnable actual;
    static final Object PARENT_DISPOSED = new Object();
    static final Object SYNC_DISPOSED = new Object();
    static final Object ASYNC_DISPOSED = new Object();
    static final Object DONE = new Object();
    static final int PARENT_INDEX = 0;
    static final int FUTURE_INDEX = 1;
    static final int THREAD_INDEX = 2;

    public ScheduledRunnable(Runnable actual, DisposableContainer parent) {
        super(3);
        this.actual = actual;
        this.lazySet(0, parent);
    }

    @Override
    public Object call() {
        this.run();
        return null;
    }

    @Override
    public void run() {
        this.lazySet(2, Thread.currentThread());
        try {
            try {
                this.actual.run();
            }
            catch (Throwable e) {
                RxJavaPlugins.onError(e);
                throw e;
            }
        }
        finally {
            this.lazySet(2, null);
            Object o = this.get(0);
            if (o != PARENT_DISPOSED && this.compareAndSet(0, o, DONE) && o != null) {
                ((DisposableContainer)o).delete(this);
            }
            while ((o = this.get(1)) != SYNC_DISPOSED && o != ASYNC_DISPOSED && !this.compareAndSet(1, o, DONE)) {
            }
        }
    }

    public void setFuture(Future<?> f) {
        Object o;
        do {
            if ((o = this.get(1)) == DONE) {
                return;
            }
            if (o == SYNC_DISPOSED) {
                f.cancel(false);
                return;
            }
            if (o != ASYNC_DISPOSED) continue;
            f.cancel(true);
            return;
        } while (!this.compareAndSet(1, o, f));
    }

    @Override
    public void dispose() {
        Object o;
        while ((o = this.get(1)) != DONE && o != SYNC_DISPOSED && o != ASYNC_DISPOSED) {
            boolean async = this.get(2) != Thread.currentThread();
            if (!this.compareAndSet(1, o, async ? ASYNC_DISPOSED : SYNC_DISPOSED)) continue;
            if (o == null) break;
            ((Future)o).cancel(async);
            break;
        }
        do {
            if ((o = this.get(0)) != DONE && o != PARENT_DISPOSED && o != null) continue;
            return;
        } while (!this.compareAndSet(0, o, PARENT_DISPOSED));
        ((DisposableContainer)o).delete(this);
    }

    @Override
    public boolean isDisposed() {
        Object o = this.get(0);
        return o == PARENT_DISPOSED || o == DONE;
    }
}

