/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(name="JUnitAssertSameCheck", summary="An object is tested for reference equality to itself using JUnit library.", severity=BugPattern.SeverityLevel.ERROR)
public class JUnitAssertSameCheck
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ASSERT_SAME_MATCHER = Matchers.staticMethod().onClassAny(new String[]{"org.junit.Assert", "junit.framework.Assert"}).named("assertSame");

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (!ASSERT_SAME_MATCHER.matches((Tree)methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = methodInvocationTree.getArguments();
        if (args.size() == 2 && ASTHelpers.sameVariable((ExpressionTree)args.get(0), (ExpressionTree)args.get(1))) {
            return this.describeMatch(methodInvocationTree);
        }
        if (args.size() == 3 && ASTHelpers.sameVariable((ExpressionTree)args.get(1), (ExpressionTree)args.get(2))) {
            return this.describeMatch(methodInvocationTree);
        }
        return Description.NO_MATCH;
    }
}

