/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.errorprone.refaster.AutoValue_UContinue;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.StringName;
import com.google.errorprone.refaster.ULabeledStatement;
import com.google.errorprone.refaster.USimpleStatement;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import javax.annotation.Nullable;

@AutoValue
abstract class UContinue
extends USimpleStatement
implements ContinueTree {
    UContinue() {
    }

    static UContinue create(@Nullable CharSequence label) {
        return new AutoValue_UContinue(label == null ? null : StringName.of(label));
    }

    @Override
    @Nullable
    public abstract StringName getLabel();

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CONTINUE;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitContinue(this, data);
    }

    private ULabeledStatement.Key key() {
        return new ULabeledStatement.Key(this.getLabel());
    }

    @Override
    public JCTree.JCContinue inline(Inliner inliner) {
        return inliner.maker().Continue(ULabeledStatement.inlineLabel(this.getLabel(), inliner));
    }

    @Override
    public Choice<Unifier> visitContinue(ContinueTree node, Unifier unifier) {
        if (this.getLabel() == null) {
            return Choice.condition(node.getLabel() == null, unifier);
        }
        CharSequence boundName = unifier.getBinding(this.key());
        return Choice.condition(boundName != null && node.getLabel().contentEquals(boundName), unifier);
    }
}

