/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.parser.UnicodeReader;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;

public class JavaTokenizer {
    private static final boolean scannerDebug = false;
    private Source source;
    private Preview preview;
    private final Log log;
    private final Tokens tokens;
    protected Tokens.TokenKind tk;
    protected int radix;
    protected Name name;
    protected int errPos = -1;
    protected UnicodeReader reader;
    protected ScannerFactory fac;
    private static final boolean hexFloatsWork = JavaTokenizer.hexFloatsWork();

    private static boolean hexFloatsWork() {
        try {
            Float.valueOf("0x1.0p1");
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    protected JavaTokenizer(ScannerFactory fac, CharBuffer buf) {
        this(fac, new UnicodeReader(fac, buf));
    }

    protected JavaTokenizer(ScannerFactory fac, char[] buf, int inputLength) {
        this(fac, new UnicodeReader(fac, buf, inputLength));
    }

    protected JavaTokenizer(ScannerFactory fac, UnicodeReader reader) {
        this.fac = fac;
        this.log = fac.log;
        this.tokens = fac.tokens;
        this.source = fac.source;
        this.preview = fac.preview;
        this.reader = reader;
    }

    protected void checkSourceLevel(int pos, Source.Feature feature) {
        if (this.preview.isPreview(feature) && !this.preview.isEnabled()) {
            this.lexError(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, pos, this.preview.disabledError(feature));
        } else if (!feature.allowedInSource(this.source)) {
            this.lexError(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, pos, feature.error(this.source.name));
        } else if (this.preview.isPreview(feature)) {
            this.preview.warnPreview(pos, feature);
        }
    }

    protected void lexError(int pos, JCDiagnostic.Error key) {
        this.log.error(pos, key);
        this.tk = Tokens.TokenKind.ERROR;
        this.errPos = pos;
    }

    protected void lexError(JCDiagnostic.DiagnosticFlag flags, int pos, JCDiagnostic.Error key) {
        this.log.error(flags, pos, key);
        this.tk = Tokens.TokenKind.ERROR;
        this.errPos = pos;
    }

    private void scanLitChar(int pos) {
        if (this.reader.ch == '\\') {
            if (this.reader.peekChar() == '\\' && !this.reader.isUnicode()) {
                this.reader.skipChar();
                this.reader.putChar('\\', true);
            } else {
                this.reader.scanChar();
                switch (this.reader.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char leadch = this.reader.ch;
                        int oct = this.reader.digit(pos, 8);
                        this.reader.scanChar();
                        if ('0' <= this.reader.ch && this.reader.ch <= '7') {
                            oct = oct * 8 + this.reader.digit(pos, 8);
                            this.reader.scanChar();
                            if (leadch <= '3' && '0' <= this.reader.ch && this.reader.ch <= '7') {
                                oct = oct * 8 + this.reader.digit(pos, 8);
                                this.reader.scanChar();
                            }
                        }
                        this.reader.putChar((char)oct);
                        break;
                    }
                    case 'b': {
                        this.reader.putChar('\b', true);
                        break;
                    }
                    case 't': {
                        this.reader.putChar('\t', true);
                        break;
                    }
                    case 'n': {
                        this.reader.putChar('\n', true);
                        break;
                    }
                    case 'f': {
                        this.reader.putChar('\f', true);
                        break;
                    }
                    case 'r': {
                        this.reader.putChar('\r', true);
                        break;
                    }
                    case '\'': {
                        this.reader.putChar('\'', true);
                        break;
                    }
                    case '\"': {
                        this.reader.putChar('\"', true);
                        break;
                    }
                    case '\\': {
                        this.reader.putChar('\\', true);
                        break;
                    }
                    default: {
                        this.lexError(this.reader.bp, CompilerProperties.Errors.IllegalEscChar);
                        break;
                    }
                }
            }
        } else if (this.reader.bp != this.reader.buflen) {
            this.reader.putChar(true);
        }
    }

    private void scanDigits(int pos, int digitRadix) {
        int savePos;
        char saveCh;
        do {
            if (this.reader.ch != '_') {
                this.reader.putChar(false);
            } else {
                this.checkSourceLevel(pos, Source.Feature.UNDERSCORES_IN_LITERALS);
            }
            saveCh = this.reader.ch;
            savePos = this.reader.bp;
            this.reader.scanChar();
        } while (this.reader.digit(pos, digitRadix) >= 0 || this.reader.ch == '_');
        if (saveCh == '_') {
            this.lexError(savePos, CompilerProperties.Errors.IllegalUnderscore);
        }
    }

    private void scanHexExponentAndSuffix(int pos) {
        if (this.reader.ch == 'p' || this.reader.ch == 'P') {
            this.reader.putChar(true);
            this.skipIllegalUnderscores();
            if (this.reader.ch == '+' || this.reader.ch == '-') {
                this.reader.putChar(true);
            }
            this.skipIllegalUnderscores();
            if (this.reader.digit(pos, 10) >= 0) {
                this.scanDigits(pos, 10);
                if (!hexFloatsWork) {
                    this.lexError(pos, CompilerProperties.Errors.UnsupportedCrossFpLit);
                }
            } else {
                this.lexError(pos, CompilerProperties.Errors.MalformedFpLit);
            }
        } else {
            this.lexError(pos, CompilerProperties.Errors.MalformedFpLit);
        }
        if (this.reader.ch == 'f' || this.reader.ch == 'F') {
            this.reader.putChar(true);
            this.tk = Tokens.TokenKind.FLOATLITERAL;
            this.radix = 16;
        } else {
            if (this.reader.ch == 'd' || this.reader.ch == 'D') {
                this.reader.putChar(true);
            }
            this.tk = Tokens.TokenKind.DOUBLELITERAL;
            this.radix = 16;
        }
    }

    private void scanFraction(int pos) {
        this.skipIllegalUnderscores();
        if (this.reader.digit(pos, 10) >= 0) {
            this.scanDigits(pos, 10);
        }
        int sp1 = this.reader.sp;
        if (this.reader.ch == 'e' || this.reader.ch == 'E') {
            this.reader.putChar(true);
            this.skipIllegalUnderscores();
            if (this.reader.ch == '+' || this.reader.ch == '-') {
                this.reader.putChar(true);
            }
            this.skipIllegalUnderscores();
            if (this.reader.digit(pos, 10) >= 0) {
                this.scanDigits(pos, 10);
                return;
            }
            this.lexError(pos, CompilerProperties.Errors.MalformedFpLit);
            this.reader.sp = sp1;
        }
    }

    private void scanFractionAndSuffix(int pos) {
        this.radix = 10;
        this.scanFraction(pos);
        if (this.reader.ch == 'f' || this.reader.ch == 'F') {
            this.reader.putChar(true);
            this.tk = Tokens.TokenKind.FLOATLITERAL;
        } else {
            if (this.reader.ch == 'd' || this.reader.ch == 'D') {
                this.reader.putChar(true);
            }
            this.tk = Tokens.TokenKind.DOUBLELITERAL;
        }
    }

    private void scanHexFractionAndSuffix(int pos, boolean seendigit) {
        this.radix = 16;
        Assert.check(this.reader.ch == '.');
        this.reader.putChar(true);
        this.skipIllegalUnderscores();
        if (this.reader.digit(pos, 16) >= 0) {
            seendigit = true;
            this.scanDigits(pos, 16);
        }
        if (!seendigit) {
            this.lexError(pos, CompilerProperties.Errors.InvalidHexNumber);
        } else {
            this.scanHexExponentAndSuffix(pos);
        }
    }

    private void skipIllegalUnderscores() {
        if (this.reader.ch == '_') {
            this.lexError(this.reader.bp, CompilerProperties.Errors.IllegalUnderscore);
            while (this.reader.ch == '_') {
                this.reader.scanChar();
            }
        }
    }

    private void scanNumber(int pos, int radix) {
        boolean seenValidDigit;
        this.radix = radix;
        int digitRadix = radix == 8 ? 10 : radix;
        int firstDigit = this.reader.digit(pos, Math.max(10, digitRadix));
        boolean seendigit = firstDigit >= 0;
        boolean bl = seenValidDigit = firstDigit >= 0 && firstDigit < digitRadix;
        if (seendigit) {
            this.scanDigits(pos, digitRadix);
        }
        if (radix == 16 && this.reader.ch == '.') {
            this.scanHexFractionAndSuffix(pos, seendigit);
        } else if (seendigit && radix == 16 && (this.reader.ch == 'p' || this.reader.ch == 'P')) {
            this.scanHexExponentAndSuffix(pos);
        } else if (digitRadix == 10 && this.reader.ch == '.') {
            this.reader.putChar(true);
            this.scanFractionAndSuffix(pos);
        } else if (digitRadix == 10 && (this.reader.ch == 'e' || this.reader.ch == 'E' || this.reader.ch == 'f' || this.reader.ch == 'F' || this.reader.ch == 'd' || this.reader.ch == 'D')) {
            this.scanFractionAndSuffix(pos);
        } else {
            if (!seenValidDigit) {
                switch (radix) {
                    case 2: {
                        this.lexError(pos, CompilerProperties.Errors.InvalidBinaryNumber);
                        break;
                    }
                    case 16: {
                        this.lexError(pos, CompilerProperties.Errors.InvalidHexNumber);
                    }
                }
            }
            if (this.reader.ch == 'l' || this.reader.ch == 'L') {
                this.reader.scanChar();
                this.tk = Tokens.TokenKind.LONGLITERAL;
            } else {
                this.tk = Tokens.TokenKind.INTLITERAL;
            }
        }
    }

    private void scanIdent() {
        this.reader.putChar(true);
        block5: while (true) {
            switch (this.reader.ch) {
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    break;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '\u007f': {
                    this.reader.scanChar();
                    continue block5;
                }
                case '\u001a': {
                    if (this.reader.bp >= this.reader.buflen) {
                        this.name = this.reader.name();
                        this.tk = this.tokens.lookupKind(this.name);
                        return;
                    }
                    this.reader.scanChar();
                    continue block5;
                }
                default: {
                    boolean isJavaIdentifierPart;
                    if (this.reader.ch < '\u0080') {
                        isJavaIdentifierPart = false;
                    } else {
                        if (Character.isIdentifierIgnorable(this.reader.ch)) {
                            this.reader.scanChar();
                            continue block5;
                        }
                        int codePoint = this.reader.peekSurrogates();
                        if (codePoint >= 0) {
                            isJavaIdentifierPart = Character.isJavaIdentifierPart(codePoint);
                            if (isJavaIdentifierPart) {
                                this.reader.putChar(true);
                            }
                        } else {
                            isJavaIdentifierPart = Character.isJavaIdentifierPart(this.reader.ch);
                        }
                    }
                    if (isJavaIdentifierPart) break;
                    this.name = this.reader.name();
                    this.tk = this.tokens.lookupKind(this.name);
                    return;
                }
            }
            this.reader.putChar(true);
        }
    }

    private boolean isSpecial(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.reader.putChar(false);
            Name newname = this.reader.name();
            Tokens.TokenKind tk1 = this.tokens.lookupKind(newname);
            if (tk1 == Tokens.TokenKind.IDENTIFIER) {
                --this.reader.sp;
                break;
            }
            this.tk = tk1;
            this.reader.scanChar();
        } while (this.isSpecial(this.reader.ch));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tokens.Token readToken() {
        List<Tokens.Comment> comments;
        int endPos;
        int pos;
        block68: {
            this.reader.sp = 0;
            this.name = null;
            this.radix = 0;
            pos = 0;
            endPos = 0;
            comments = null;
            block28: while (true) {
                Tokens.Comment.CommentStyle style;
                boolean isEmpty;
                pos = this.reader.bp;
                switch (this.reader.ch) {
                    case '\t': 
                    case '\f': 
                    case ' ': {
                        do {
                            this.reader.scanChar();
                        } while (this.reader.ch == ' ' || this.reader.ch == '\t' || this.reader.ch == '\f');
                        this.processWhiteSpace(pos, this.reader.bp);
                        continue block28;
                    }
                    case '\n': {
                        this.reader.scanChar();
                        this.processLineTerminator(pos, this.reader.bp);
                        continue block28;
                    }
                    case '\r': {
                        this.reader.scanChar();
                        if (this.reader.ch == '\n') {
                            this.reader.scanChar();
                        }
                        this.processLineTerminator(pos, this.reader.bp);
                        continue block28;
                    }
                    case '$': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.scanIdent();
                        break block68;
                    }
                    case '0': {
                        int savePos;
                        this.reader.scanChar();
                        if (this.reader.ch == 'x' || this.reader.ch == 'X') {
                            this.reader.scanChar();
                            this.skipIllegalUnderscores();
                            this.scanNumber(pos, 16);
                            break block68;
                        }
                        if (this.reader.ch == 'b' || this.reader.ch == 'B') {
                            this.checkSourceLevel(pos, Source.Feature.BINARY_LITERALS);
                            this.reader.scanChar();
                            this.skipIllegalUnderscores();
                            this.scanNumber(pos, 2);
                            break block68;
                        } else {
                            this.reader.putChar('0');
                            if (this.reader.ch == '_') {
                                savePos = this.reader.bp;
                                do {
                                    this.reader.scanChar();
                                } while (this.reader.ch == '_');
                                if (this.reader.digit(pos, 10) < 0) {
                                    this.lexError(savePos, CompilerProperties.Errors.IllegalUnderscore);
                                }
                            }
                            this.scanNumber(pos, 8);
                        }
                        break block68;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.scanNumber(pos, 10);
                        break block68;
                    }
                    case '.': {
                        int savePos;
                        this.reader.scanChar();
                        if (this.reader.digit(pos, 10) >= 0) {
                            this.reader.putChar('.');
                            this.scanFractionAndSuffix(pos);
                            break block68;
                        }
                        if (this.reader.ch == '.') {
                            savePos = this.reader.bp;
                            this.reader.putChar('.');
                            this.reader.putChar('.', true);
                            if (this.reader.ch == '.') {
                                this.reader.scanChar();
                                this.reader.putChar('.');
                                this.tk = Tokens.TokenKind.ELLIPSIS;
                                break block68;
                            } else {
                                this.lexError(savePos, CompilerProperties.Errors.IllegalDot);
                            }
                            break block68;
                        }
                        this.tk = Tokens.TokenKind.DOT;
                        break block68;
                    }
                    case ',': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.COMMA;
                        break block68;
                    }
                    case ';': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.SEMI;
                        break block68;
                    }
                    case '(': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.LPAREN;
                        break block68;
                    }
                    case ')': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.RPAREN;
                        break block68;
                    }
                    case '[': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.LBRACKET;
                        break block68;
                    }
                    case ']': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.RBRACKET;
                        break block68;
                    }
                    case '{': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.LBRACE;
                        break block68;
                    }
                    case '}': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.RBRACE;
                        break block68;
                    }
                    case '/': {
                        this.reader.scanChar();
                        if (this.reader.ch == '/') {
                            do {
                                this.reader.scanCommentChar();
                            } while (this.reader.ch != '\r' && this.reader.ch != '\n' && this.reader.bp < this.reader.buflen);
                            if (this.reader.bp >= this.reader.buflen) continue block28;
                            comments = this.addComment(comments, this.processComment(pos, this.reader.bp, Tokens.Comment.CommentStyle.LINE));
                            continue block28;
                        }
                        if (this.reader.ch == '*') {
                            isEmpty = false;
                            this.reader.scanChar();
                            if (this.reader.ch == '*') {
                                style = Tokens.Comment.CommentStyle.JAVADOC;
                                this.reader.scanCommentChar();
                                if (this.reader.ch != '/') break;
                                isEmpty = true;
                                break;
                            }
                            style = Tokens.Comment.CommentStyle.BLOCK;
                            break;
                        }
                        if (this.reader.ch == '=') {
                            this.tk = Tokens.TokenKind.SLASHEQ;
                            this.reader.scanChar();
                            break block68;
                        } else {
                            this.tk = Tokens.TokenKind.SLASH;
                        }
                        break block68;
                    }
                    case '\'': {
                        this.reader.scanChar();
                        if (this.reader.ch == '\'') {
                            this.lexError(pos, CompilerProperties.Errors.EmptyCharLit);
                            this.reader.scanChar();
                            break block68;
                        }
                        if (this.reader.ch == '\r' || this.reader.ch == '\n') {
                            this.lexError(pos, CompilerProperties.Errors.IllegalLineEndInCharLit);
                        }
                        this.scanLitChar(pos);
                        if (this.reader.ch == '\'') {
                            this.reader.scanChar();
                            this.tk = Tokens.TokenKind.CHARLITERAL;
                            break block68;
                        } else {
                            this.lexError(pos, CompilerProperties.Errors.UnclosedCharLit);
                        }
                        break block68;
                    }
                    case '\"': {
                        this.reader.scanChar();
                        while (this.reader.ch != '\"' && this.reader.ch != '\r' && this.reader.ch != '\n' && this.reader.bp < this.reader.buflen) {
                            this.scanLitChar(pos);
                        }
                        if (this.reader.ch == '\"') {
                            this.tk = Tokens.TokenKind.STRINGLITERAL;
                            this.reader.scanChar();
                            break block68;
                        } else {
                            this.lexError(pos, CompilerProperties.Errors.UnclosedStrLit);
                        }
                        break block68;
                    }
                    default: {
                        boolean isJavaIdentifierStart;
                        if (this.isSpecial(this.reader.ch)) {
                            this.scanOperator();
                            break block68;
                        }
                        int codePoint = -1;
                        if (this.reader.ch < '\u0080') {
                            isJavaIdentifierStart = false;
                        } else {
                            codePoint = this.reader.peekSurrogates();
                            if (codePoint >= 0) {
                                isJavaIdentifierStart = Character.isJavaIdentifierStart(codePoint);
                                if (isJavaIdentifierStart) {
                                    this.reader.putChar(true);
                                }
                            } else {
                                isJavaIdentifierStart = Character.isJavaIdentifierStart(this.reader.ch);
                            }
                        }
                        if (isJavaIdentifierStart) {
                            this.scanIdent();
                            break block68;
                        }
                        if (this.reader.digit(pos, 10) >= 0) {
                            this.scanNumber(pos, 10);
                            break block68;
                        }
                        if (this.reader.bp == this.reader.buflen || this.reader.ch == '\u001a' && this.reader.bp + 1 == this.reader.buflen) {
                            this.tk = Tokens.TokenKind.EOF;
                            pos = this.reader.buflen;
                            break block68;
                        } else {
                            String arg;
                            if (codePoint >= 0) {
                                char high = this.reader.ch;
                                this.reader.scanChar();
                                arg = String.format("\\u%04x\\u%04x", high, (int)this.reader.ch);
                            } else {
                                arg = ' ' < this.reader.ch && this.reader.ch < '\u007f' ? String.format("%s", Character.valueOf(this.reader.ch)) : String.format("\\u%04x", this.reader.ch);
                            }
                            this.lexError(pos, CompilerProperties.Errors.IllegalChar(arg));
                            this.reader.scanChar();
                        }
                        break block68;
                    }
                }
                while (!isEmpty && this.reader.bp < this.reader.buflen) {
                    if (this.reader.ch == '*') {
                        this.reader.scanChar();
                        if (this.reader.ch != '/') continue;
                        break;
                    }
                    this.reader.scanCommentChar();
                }
                if (this.reader.ch != '/') break;
                this.reader.scanChar();
                comments = this.addComment(comments, this.processComment(pos, this.reader.bp, style));
            }
            this.lexError(pos, CompilerProperties.Errors.UnclosedComment);
        }
        endPos = this.reader.bp;
        switch (this.tk.tag) {
            case DEFAULT: {
                return new Tokens.Token(this.tk, pos, endPos, comments);
            }
            case NAMED: {
                return new Tokens.NamedToken(this.tk, pos, endPos, this.name, comments);
            }
            case STRING: {
                return new Tokens.StringToken(this.tk, pos, endPos, this.reader.chars(), comments);
            }
            case NUMERIC: {
                return new Tokens.NumericToken(this.tk, pos, endPos, this.reader.chars(), this.radix, comments);
            }
        }
        throw new AssertionError();
    }

    List<Tokens.Comment> addComment(List<Tokens.Comment> comments, Tokens.Comment comment) {
        return comments == null ? List.of(comment) : comments.prepend(comment);
    }

    public int errPos() {
        return this.errPos;
    }

    public void errPos(int pos) {
        this.errPos = pos;
    }

    protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
        char[] buf = this.reader.getRawCharacters(pos, endPos);
        return new BasicComment<UnicodeReader>(new UnicodeReader(this.fac, buf, buf.length), style);
    }

    protected void processWhiteSpace(int pos, int endPos) {
    }

    protected void processLineTerminator(int pos, int endPos) {
    }

    public Position.LineMap getLineMap() {
        return Position.makeLineMap(this.reader.getRawCharacters(), this.reader.buflen, false);
    }

    protected static class BasicComment<U extends UnicodeReader>
    implements Tokens.Comment {
        Tokens.Comment.CommentStyle cs;
        U comment_reader;
        protected boolean deprecatedFlag = false;
        protected boolean scanned = false;

        protected BasicComment(U comment_reader, Tokens.Comment.CommentStyle cs) {
            this.comment_reader = comment_reader;
            this.cs = cs;
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public int getSourcePos(int pos) {
            return -1;
        }

        @Override
        public Tokens.Comment.CommentStyle getStyle() {
            return this.cs;
        }

        @Override
        public boolean isDeprecated() {
            if (!this.scanned && this.cs == Tokens.Comment.CommentStyle.JAVADOC) {
                this.scanDocComment();
            }
            return this.deprecatedFlag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void scanDocComment() {
            try {
                boolean deprecatedPrefix = false;
                ((UnicodeReader)this.comment_reader).bp += 3;
                ((UnicodeReader)this.comment_reader).ch = ((UnicodeReader)this.comment_reader).buf[((UnicodeReader)this.comment_reader).bp];
                block11: while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen) {
                    while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen && (((UnicodeReader)this.comment_reader).ch == ' ' || ((UnicodeReader)this.comment_reader).ch == '\t' || ((UnicodeReader)this.comment_reader).ch == '\f')) {
                        ((UnicodeReader)this.comment_reader).scanCommentChar();
                    }
                    while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen && ((UnicodeReader)this.comment_reader).ch == '*') {
                        ((UnicodeReader)this.comment_reader).scanCommentChar();
                        if (((UnicodeReader)this.comment_reader).ch != '/') continue;
                        return;
                    }
                    while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen && (((UnicodeReader)this.comment_reader).ch == ' ' || ((UnicodeReader)this.comment_reader).ch == '\t' || ((UnicodeReader)this.comment_reader).ch == '\f')) {
                        ((UnicodeReader)this.comment_reader).scanCommentChar();
                    }
                    deprecatedPrefix = false;
                    if (!this.deprecatedFlag) {
                        String deprecated = "@deprecated";
                        int i = 0;
                        while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen && ((UnicodeReader)this.comment_reader).ch == deprecated.charAt(i)) {
                            ((UnicodeReader)this.comment_reader).scanCommentChar();
                            if (++i != deprecated.length()) continue;
                            deprecatedPrefix = true;
                            break;
                        }
                    }
                    if (deprecatedPrefix && ((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen) {
                        if (Character.isWhitespace(((UnicodeReader)this.comment_reader).ch)) {
                            this.deprecatedFlag = true;
                        } else if (((UnicodeReader)this.comment_reader).ch == '*') {
                            ((UnicodeReader)this.comment_reader).scanCommentChar();
                            if (((UnicodeReader)this.comment_reader).ch == '/') {
                                this.deprecatedFlag = true;
                                return;
                            }
                        }
                    }
                    block16: while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen) {
                        switch (((UnicodeReader)this.comment_reader).ch) {
                            case '*': {
                                ((UnicodeReader)this.comment_reader).scanCommentChar();
                                if (((UnicodeReader)this.comment_reader).ch != '/') continue block16;
                                return;
                            }
                            case '\r': {
                                ((UnicodeReader)this.comment_reader).scanCommentChar();
                                if (((UnicodeReader)this.comment_reader).ch != '\n') continue block11;
                            }
                            case '\n': {
                                ((UnicodeReader)this.comment_reader).scanCommentChar();
                                continue block11;
                            }
                        }
                        ((UnicodeReader)this.comment_reader).scanCommentChar();
                    }
                }
                return;
            }
            finally {
                this.scanned = true;
            }
        }
    }
}

