/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.StackSizeComputer;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.info.MethodOptimizationInfo;

public class NonEmptyStackReturnMarker
extends SimplifiedVisitor
implements InstructionVisitor {
    private final StackSizeComputer stackSizeComputer;

    public NonEmptyStackReturnMarker(StackSizeComputer stackSizeComputer) {
        this.stackSizeComputer = stackSizeComputer;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case -83: 
            case -81: {
                this.markReturnWithNonEmptyStack(method, n, 2);
                break;
            }
            case -84: 
            case -82: 
            case -80: {
                this.markReturnWithNonEmptyStack(method, n, 1);
                break;
            }
            case -79: {
                this.markReturnWithNonEmptyStack(method, n, 0);
            }
        }
    }

    private void markReturnWithNonEmptyStack(Method method, int n, int n2) {
        if (!this.stackSizeComputer.isReachable(n) || this.stackSizeComputer.getStackSizeBefore(n) > n2) {
            NonEmptyStackReturnMarker.setReturnsWithNonEmptyStack(method);
        }
    }

    private static void setReturnsWithNonEmptyStack(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setReturnsWithNonEmptyStack();
        }
    }

    public static boolean returnsWithNonEmptyStack(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo == null || methodOptimizationInfo.returnsWithNonEmptyStack();
    }
}

