/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Convert;
import javax.lang.model.type.TypeKind;

@BugPattern(name="StringBuilderInitWithChar", severity=BugPattern.SeverityLevel.ERROR, summary="StringBuilder does not have a char constructor; this invokes the int constructor.")
public class StringBuilderInitWithChar
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        ExpressionTree argument;
        Type type;
        if (ASTHelpers.isSameType((Type)state.getSymtab().stringBuilderType, (Type)ASTHelpers.getType((Tree)tree.getIdentifier()), (VisitorState)state) && tree.getArguments().size() == 1 && (type = ASTHelpers.getType((Tree)(argument = tree.getArguments().get(0)))).getKind() == TypeKind.CHAR) {
            if (argument.getKind() == Tree.Kind.CHAR_LITERAL) {
                char ch = ((Character)((LiteralTree)argument).getValue()).charValue();
                return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)argument, (String)("\"" + Convert.quote(Character.toString(ch)) + "\"")));
            }
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)("new StringBuilder().append(" + state.getSourceForNode((Tree)((JCTree)((Object)argument))) + ")")));
        }
        return Description.NO_MATCH;
    }
}

