/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayDeque;
import java.util.List;
import java.util.regex.Pattern;

@BugPattern(name="ImplementAssertionWithChaining", summary="Prefer check(...), which usually generates more readable failure messages.", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class ImplementAssertionWithChaining
extends BugChecker
implements BugChecker.IfTreeMatcher {
    private static final Matcher<ExpressionTree> FAIL_METHOD = Matchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").withNameMatching(Pattern.compile("fail.*"));
    private static final Matcher<ExpressionTree> EQUALS_LIKE_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().anyClass().named("equals").withParameters(new String[]{"java.lang.Object"}), Matchers.staticMethod().onClass("com.google.common.base.Objects").named("equal"), Matchers.staticMethod().onClass("java.util.Objects").named("equals")});
    private static final Matcher<ExpressionTree> ACTUAL_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").named("actual").withParameters(new String[0]), Matchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").named("getSubject").withParameters(new String[0])});

    public Description matchIf(IfTree ifTree, VisitorState state) {
        if (ifTree.getElseStatement() != null) {
            return Description.NO_MATCH;
        }
        if (!ImplementAssertionWithChaining.isCallToFail(ifTree.getThenStatement(), state)) {
            return Description.NO_MATCH;
        }
        ImmutableList<ExpressionTree> actualAndExpected = ImplementAssertionWithChaining.findActualAndExpected(ASTHelpers.stripParentheses((ExpressionTree)ifTree.getCondition()), state);
        if (actualAndExpected == null) {
            return Description.NO_MATCH;
        }
        String checkDescription = ImplementAssertionWithChaining.makeCheckDescription((ExpressionTree)actualAndExpected.get(0), state);
        if (checkDescription == null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(ifTree, (Fix)SuggestedFix.replace((Tree)ifTree, (String)String.format("check(%s).that(%s).isEqualTo(%s);", checkDescription, state.getSourceForNode((Tree)actualAndExpected.get(0)), state.getSourceForNode((Tree)actualAndExpected.get(1)))));
    }

    private static ImmutableList<ExpressionTree> findActualAndExpected(ExpressionTree condition, VisitorState state) {
        switch (condition.getKind()) {
            case LOGICAL_COMPLEMENT: {
                return ImplementAssertionWithChaining.findActualAndExpectedForPossibleEqualsCall(ASTHelpers.stripParentheses((ExpressionTree)((UnaryTree)condition).getExpression()), state);
            }
            case NOT_EQUAL_TO: {
                return ImplementAssertionWithChaining.findActualAndExpectedForBinaryOp((BinaryTree)condition, state);
            }
        }
        return null;
    }

    private static ImmutableList<ExpressionTree> findActualAndExpectedForPossibleEqualsCall(ExpressionTree possiblyEqualsCall, VisitorState state) {
        if (!EQUALS_LIKE_METHOD.matches((Tree)possiblyEqualsCall, state)) {
            return null;
        }
        MethodInvocationTree equalsCheck = (MethodInvocationTree)possiblyEqualsCall;
        List<? extends ExpressionTree> args = equalsCheck.getArguments();
        return args.size() == 2 ? ImmutableList.copyOf(args) : ImmutableList.of((Object)((MemberSelectTree)equalsCheck.getMethodSelect()).getExpression(), (Object)Iterables.getOnlyElement(args));
    }

    private static ImmutableList<ExpressionTree> findActualAndExpectedForBinaryOp(BinaryTree binaryTree, VisitorState state) {
        boolean bothEnums;
        boolean bothPrimitives = ASTHelpers.getType((Tree)binaryTree.getLeftOperand()).isPrimitive() && ASTHelpers.getType((Tree)binaryTree.getRightOperand()).isPrimitive();
        boolean bl = bothEnums = ImplementAssertionWithChaining.isEnum(binaryTree.getLeftOperand(), state) && ImplementAssertionWithChaining.isEnum(binaryTree.getRightOperand(), state);
        if (!bothPrimitives && !bothEnums) {
            return null;
        }
        return ImmutableList.of((Object)binaryTree.getLeftOperand(), (Object)binaryTree.getRightOperand());
    }

    private static boolean isEnum(ExpressionTree tree, VisitorState state) {
        return ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)tree), (Type)state.getTypeFromString("java.lang.Enum"), (VisitorState)state);
    }

    private static boolean isCallToFail(StatementTree then, VisitorState state) {
        while (then.getKind() == Tree.Kind.BLOCK) {
            List<? extends StatementTree> statements = ((BlockTree)then).getStatements();
            if (statements.size() != 1) {
                return false;
            }
            then = (StatementTree)Iterables.getOnlyElement(statements);
        }
        if (then.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            return false;
        }
        ExpressionTree thenExpr = ((ExpressionStatementTree)then).getExpression();
        if (thenExpr.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return false;
        }
        MethodInvocationTree thenCall = (MethodInvocationTree)thenExpr;
        ExpressionTree methodSelect = thenCall.getMethodSelect();
        if (methodSelect.getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        return FAIL_METHOD.matches((Tree)methodSelect, state);
    }

    static String makeCheckDescription(ExpressionTree actual, VisitorState state) {
        if (actual.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        ArrayDeque<String> parts = new ArrayDeque<String>();
        MethodInvocationTree invocation = (MethodInvocationTree)actual;
        ExpressionTree methodSelect;
        while ((methodSelect = invocation.getMethodSelect()).getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree memberSelect = (MemberSelectTree)methodSelect;
            if (!invocation.getArguments().isEmpty()) {
                return null;
            }
            parts.addFirst(memberSelect.getIdentifier() + "()");
            ExpressionTree expression = memberSelect.getExpression();
            if (ACTUAL_METHOD.matches((Tree)expression, state) || ImplementAssertionWithChaining.refersToFieldNamedActual(expression)) {
                return '\"' + Joiner.on((char)'.').join(parts) + '\"';
            }
            if (expression.getKind() != Tree.Kind.METHOD_INVOCATION) {
                return null;
            }
            invocation = (MethodInvocationTree)expression;
        }
        return null;
    }

    private static boolean refersToFieldNamedActual(ExpressionTree tree) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return symbol != null && symbol.getKind().isField() && symbol.getSimpleName().contentEquals("actual");
    }
}

