/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_MixedMutabilityReturnType_TypeDetails;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.lang.model.type.TypeKind;

@BugPattern(name="MixedMutabilityReturnType", summary="This method returns both mutable and immutable collections or maps from different paths. This may be confusing for users of the method.", severity=BugPattern.SeverityLevel.WARNING)
public final class MixedMutabilityReturnType
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> IMMUTABLE_FACTORY = MethodMatchers.staticMethod().onClass("java.util.Collections").namedAnyOf(new String[]{"emptyList", "emptyMap", "emptySet", "singleton", "singletonList"});
    private static final Matcher<ExpressionTree> EMPTY_INITIALIZER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass("java.util.ArrayList").withParameters(new String[0]), MethodMatchers.constructor().forClass("java.util.HashMap").withParameters(new String[0]), MethodMatchers.staticMethod().onClass("com.google.common.collect.Lists").namedAnyOf(new String[]{"newArrayList", "newLinkedList"}).withParameters(new String[0]), MethodMatchers.staticMethod().onClass("com.google.common.collect.Sets").namedAnyOf(new String[]{"newHashSet", "newLinkedHashSet"}).withParameters(new String[0])});
    private static final Matcher<ExpressionTree> IMMUTABLE = Matchers.anyOf((Matcher[])new Matcher[]{IMMUTABLE_FACTORY, Matchers.isSubtypeOf(ImmutableCollection.class), Matchers.isSubtypeOf(ImmutableMap.class)});
    private static final Matcher<ExpressionTree> MUTABLE = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSubtypeOf(ArrayList.class), Matchers.isSubtypeOf(LinkedHashSet.class), Matchers.isSubtypeOf(LinkedHashMap.class), Matchers.isSubtypeOf(LinkedList.class), Matchers.isSubtypeOf(HashMap.class), Matchers.isSubtypeOf(HashBiMap.class), Matchers.isSubtypeOf(TreeMap.class)});
    private static final Matcher<Tree> RETURNS_COLLECTION = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSubtypeOf(Collection.class), Matchers.isSubtypeOf(Map.class)});
    private static final ImmutableMap<Matcher<Tree>, TypeDetails> REFACTORING_DETAILS = ImmutableMap.of((Object)Matchers.isSubtypeOf(BiMap.class), (Object)TypeDetails.of("com.google.common.collect.ImmutableBiMap", (Matcher<ExpressionTree>)MethodMatchers.instanceMethod().onDescendantOf(BiMap.class.getName()).namedAnyOf(new String[]{"put", "putAll"}), (Matcher<Tree>)Matchers.nothing()), (Object)Matchers.isSubtypeOf(Map.class), (Object)TypeDetails.of("com.google.common.collect.ImmutableMap", (Matcher<ExpressionTree>)MethodMatchers.instanceMethod().onDescendantOf(Map.class.getName()).namedAnyOf(new String[]{"put", "putAll"}), (Matcher<Tree>)Matchers.isSubtypeOf(SortedMap.class)), (Object)Matchers.isSubtypeOf(List.class), (Object)TypeDetails.of("com.google.common.collect.ImmutableList", (Matcher<ExpressionTree>)MethodMatchers.instanceMethod().onDescendantOf(List.class.getName()).namedAnyOf(new String[]{"add", "addAll"}), (Matcher<Tree>)Matchers.nothing()), (Object)Matchers.isSubtypeOf(Set.class), (Object)TypeDetails.of("com.google.common.collect.ImmutableSet", (Matcher<ExpressionTree>)MethodMatchers.instanceMethod().onDescendantOf(Set.class.getName()).namedAnyOf(new String[]{"add", "addAll"}), (Matcher<Tree>)Matchers.nothing()));

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        VariableMutabilityScanner variableMutabilityScanner = new VariableMutabilityScanner(state);
        variableMutabilityScanner.scan(state.getPath(), null);
        new ReturnTypesScanner(state, variableMutabilityScanner.immutable, variableMutabilityScanner.mutable).scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private static ImmutableList<SuggestedFix> generateFixes(List<ReturnTree> returnTrees, TreePath methodTree, VisitorState state) {
        ReturnTree returnTree;
        SuggestedFix.Builder simpleFix = SuggestedFix.builder();
        SuggestedFix.Builder fixWithBuilders = SuggestedFix.builder();
        boolean anyBuilderFixes = false;
        Matcher returnTypeMatcher = null;
        for (Map.Entry entry : REFACTORING_DETAILS.entrySet()) {
            Tree returnType = ((MethodTree)methodTree.getLeaf()).getReturnType();
            Matcher matcher = (Matcher)entry.getKey();
            if (!matcher.matches(returnType, state)) continue;
            if (!ASTHelpers.methodCanBeOverridden((Symbol.MethodSymbol)ASTHelpers.getSymbol((MethodTree)((MethodTree)methodTree.getLeaf())))) {
                SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
                fixBuilder.replace(ASTHelpers.getErasedTypeTree((Tree)returnType), SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (String)((TypeDetails)entry.getValue()).immutableType()));
                simpleFix.merge(fixBuilder);
                fixWithBuilders.merge(fixBuilder);
            }
            returnTypeMatcher = Matchers.isSubtypeOf((String)((TypeDetails)entry.getValue()).immutableType());
            break;
        }
        if (returnTypeMatcher == null) {
            return ImmutableList.of();
        }
        Iterator<ReturnTree> iterator = returnTrees.iterator();
        while (iterator.hasNext() && !returnTypeMatcher.matches((Tree)(returnTree = (ReturnTree)iterator.next()).getExpression(), state)) {
            for (Map.Entry entry : REFACTORING_DETAILS.entrySet()) {
                SuggestedFix simple;
                Matcher predicate = (Matcher)entry.getKey();
                TypeDetails typeDetails = (TypeDetails)entry.getValue();
                ExpressionTree expression = returnTree.getExpression();
                if (!predicate.matches((Tree)expression, state)) continue;
                if (expression instanceof IdentifierTree) {
                    simple = MixedMutabilityReturnType.applySimpleFix(typeDetails.immutableType(), expression, state);
                    ReturnTypeFixer returnTypeFixer = new ReturnTypeFixer(ASTHelpers.getSymbol((Tree)expression), typeDetails, state);
                    returnTypeFixer.scan(methodTree, null);
                    anyBuilderFixes |= !returnTypeFixer.failed;
                    simpleFix.merge(simple);
                    fixWithBuilders.merge(returnTypeFixer.failed ? simple : returnTypeFixer.fix.build());
                    continue;
                }
                if (IMMUTABLE_FACTORY.matches((Tree)expression, state)) {
                    SuggestedFix.Builder fix = SuggestedFix.builder();
                    fix.replace((Tree)((MethodInvocationTree)expression).getMethodSelect(), SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)typeDetails.immutableType()) + ".of");
                    simpleFix.merge(fix);
                    fixWithBuilders.merge(fix);
                    continue;
                }
                simple = MixedMutabilityReturnType.applySimpleFix(typeDetails.immutableType(), expression, state);
                simpleFix.merge(simple);
                fixWithBuilders.merge(simple);
            }
        }
        if (!anyBuilderFixes) {
            return ImmutableList.of((Object)simpleFix.build());
        }
        return ImmutableList.of((Object)simpleFix.build(), (Object)fixWithBuilders.setShortDescription("Fix using builders. Warning: this may change behaviour if duplicate keys are added to ImmutableMap.Builder.").build());
    }

    private static SuggestedFix applySimpleFix(String immutableType, ExpressionTree expression, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace((Tree)expression, String.format("%s.copyOf(%s)", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)immutableType), state.getSourceForNode((Tree)expression)));
        return fix.build();
    }

    @AutoValue
    static abstract class TypeDetails {
        TypeDetails() {
        }

        abstract String immutableType();

        abstract String builderType();

        abstract Matcher<ExpressionTree> appendMethods();

        abstract Matcher<Tree> skipTypes();

        static TypeDetails of(String immutableType, Matcher<ExpressionTree> appendMethods, Matcher<Tree> skipTypes) {
            return new AutoValue_MixedMutabilityReturnType_TypeDetails(immutableType, immutableType + ".Builder", appendMethods, skipTypes);
        }
    }

    private static final class ReturnTypeFixer
    extends TreePathScanner<Void, Void> {
        private final Symbol symbol;
        private final TypeDetails details;
        private final VisitorState state;
        private final SuggestedFix.Builder fix = SuggestedFix.builder();
        private boolean builderifiedVariable = false;
        private boolean failed = false;

        private ReturnTypeFixer(Symbol symbol, TypeDetails details, VisitorState state) {
            this.symbol = symbol;
            this.details = details;
            this.state = state;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Void unused) {
            if (!ASTHelpers.getSymbol((VariableTree)variableTree).equals(this.symbol)) {
                return (Void)super.visitVariable(variableTree, null);
            }
            if (variableTree.getInitializer() == null || !EMPTY_INITIALIZER.matches((Tree)variableTree.getInitializer(), this.state) || this.details.skipTypes().matches((Tree)variableTree.getInitializer(), this.state)) {
                this.failed = true;
                return null;
            }
            this.fix.replace(ASTHelpers.getErasedTypeTree((Tree)variableTree.getType()), SuggestedFixes.qualifyType((VisitorState)this.state, (SuggestedFix.Builder)this.fix, (String)this.details.builderType()));
            if (variableTree.getInitializer() != null) {
                this.fix.replace((Tree)variableTree.getInitializer(), SuggestedFixes.qualifyType((VisitorState)this.state, (SuggestedFix.Builder)this.fix, (String)this.details.immutableType()) + ".builder()");
            }
            this.builderifiedVariable = true;
            return (Void)super.visitVariable(variableTree, null);
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifier, Void unused) {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            if (!ASTHelpers.getSymbol((Tree)identifier).equals(this.symbol)) {
                return null;
            }
            if (parent instanceof VariableTree) {
                VariableTree variable = (VariableTree)parent;
                this.fix.replace(variable.getType(), SuggestedFixes.qualifyType((VisitorState)this.state, (SuggestedFix.Builder)this.fix, (String)this.details.builderType()));
                return null;
            }
            if (parent instanceof MemberSelectTree) {
                Tree grandParent = this.getCurrentPath().getParentPath().getParentPath().getLeaf();
                if (grandParent instanceof MethodInvocationTree && !this.details.appendMethods().matches((Tree)((MethodInvocationTree)grandParent), this.state)) {
                    this.failed = true;
                    return null;
                }
                return null;
            }
            if (!this.builderifiedVariable) {
                this.failed = true;
                return null;
            }
            if (parent instanceof ReturnTree) {
                this.fix.postfixWith((Tree)identifier, ".build()");
            }
            return null;
        }
    }

    private final class ReturnTypesScanner
    extends BugChecker.SuppressibleTreePathScanner<Void, Void> {
        private final VisitorState state;
        private final Set<Symbol.VarSymbol> mutable;
        private final Set<Symbol.VarSymbol> immutable;

        private ReturnTypesScanner(VisitorState state, Set<Symbol.VarSymbol> immutable, Set<Symbol.VarSymbol> mutable) {
            super((BugChecker)MixedMutabilityReturnType.this);
            this.state = state;
            this.immutable = immutable;
            this.mutable = mutable;
        }

        public Void visitMethod(MethodTree methodTree, Void unused) {
            if (!RETURNS_COLLECTION.matches(methodTree.getReturnType(), this.state)) {
                return (Void)super.visitMethod(methodTree, (Object)unused);
            }
            MethodScanner scanner = new MethodScanner();
            scanner.scan(this.getCurrentPath(), null);
            if (!scanner.immutableReturns.isEmpty() && !scanner.mutableReturns.isEmpty()) {
                this.state.reportMatch(MixedMutabilityReturnType.this.buildDescription(methodTree).addAllFixes((List)MixedMutabilityReturnType.generateFixes((List)ImmutableList.builder().addAll((Iterable)scanner.mutableReturns).addAll((Iterable)scanner.immutableReturns).build(), this.getCurrentPath(), this.state)).build());
            }
            return (Void)super.visitMethod(methodTree, (Object)unused);
        }

        private final class MethodScanner
        extends TreePathScanner<Void, Void> {
            private final List<ReturnTree> immutableReturns = new ArrayList<ReturnTree>();
            private final List<ReturnTree> mutableReturns = new ArrayList<ReturnTree>();
            private boolean skipMethods = false;

            private MethodScanner() {
            }

            @Override
            public Void visitMethod(MethodTree node, Void unused) {
                if (this.skipMethods) {
                    return null;
                }
                this.skipMethods = true;
                return (Void)super.visitMethod(node, null);
            }

            @Override
            public Void visitReturn(ReturnTree returnTree, Void unused) {
                Type type;
                if (returnTree.getExpression() instanceof IdentifierTree) {
                    Symbol symbol = ASTHelpers.getSymbol((Tree)returnTree.getExpression());
                    if (ReturnTypesScanner.this.mutable.contains(symbol)) {
                        this.mutableReturns.add(returnTree);
                        return (Void)super.visitReturn(returnTree, null);
                    }
                    if (ReturnTypesScanner.this.immutable.contains(symbol)) {
                        this.immutableReturns.add(returnTree);
                        return (Void)super.visitReturn(returnTree, null);
                    }
                }
                if ((type = ASTHelpers.getType((Tree)returnTree.getExpression())) == null || type.getKind() == TypeKind.NULL) {
                    return (Void)super.visitReturn(returnTree, null);
                }
                if (IMMUTABLE.matches((Tree)returnTree.getExpression(), ReturnTypesScanner.this.state)) {
                    this.immutableReturns.add(returnTree);
                }
                if (MUTABLE.matches((Tree)returnTree.getExpression(), ReturnTypesScanner.this.state)) {
                    this.mutableReturns.add(returnTree);
                }
                return (Void)super.visitReturn(returnTree, null);
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return null;
            }
        }
    }

    private static final class VariableMutabilityScanner
    extends TreePathScanner<Void, Void> {
        private final VisitorState state;
        private final Set<Symbol.VarSymbol> mutable = new HashSet<Symbol.VarSymbol>();
        private final Set<Symbol.VarSymbol> immutable = new HashSet<Symbol.VarSymbol>();

        private VariableMutabilityScanner(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Void unused) {
            Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)variableTree);
            ExpressionTree initializer = variableTree.getInitializer();
            if (initializer != null && ASTHelpers.getType((Tree)initializer) != null && ASTHelpers.getType((Tree)initializer).getKind() != TypeKind.NULL && RETURNS_COLLECTION.matches((Tree)initializer, this.state)) {
                if (IMMUTABLE.matches((Tree)initializer, this.state)) {
                    this.immutable.add(symbol);
                }
                if (MUTABLE.matches((Tree)initializer, this.state)) {
                    this.mutable.add(symbol);
                }
            }
            return (Void)super.visitVariable(variableTree, unused);
        }
    }
}

